/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fis.FisAsyncClient;
import software.amazon.awssdk.services.fis.internal.UserAgentUtils;
import software.amazon.awssdk.services.fis.model.ActionSummary;
import software.amazon.awssdk.services.fis.model.ListActionsRequest;
import software.amazon.awssdk.services.fis.model.ListActionsResponse;

public class ListActionsPublisher
implements SdkPublisher<ListActionsResponse> {
    private final FisAsyncClient client;
    private final ListActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListActionsPublisher(FisAsyncClient client, ListActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListActionsPublisher(FisAsyncClient client, ListActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActionSummary> actions() {
        Function<ListActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actions() != null) {
                return response.actions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListActionsResponseFetcher
    implements AsyncPageFetcher<ListActionsResponse> {
        private ListActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListActionsResponse> nextPage(ListActionsResponse previousPage) {
            if (previousPage == null) {
                return ListActionsPublisher.this.client.listActions(ListActionsPublisher.this.firstRequest);
            }
            return ListActionsPublisher.this.client.listActions((ListActionsRequest)((Object)ListActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

