/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExperimentReportStatus {
    PENDING("pending"),
    RUNNING("running"),
    COMPLETED("completed"),
    CANCELLED("cancelled"),
    FAILED("failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExperimentReportStatus> VALUE_MAP;
    private final String value;

    private ExperimentReportStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExperimentReportStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExperimentReportStatus> knownValues() {
        EnumSet<ExperimentReportStatus> knownValues = EnumSet.allOf(ExperimentReportStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExperimentReportStatus.class, ExperimentReportStatus::toString);
    }
}

