/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccountTargeting {
    SINGLE_ACCOUNT("single-account"),
    MULTI_ACCOUNT("multi-account"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccountTargeting> VALUE_MAP;
    private final String value;

    private AccountTargeting(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountTargeting fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccountTargeting> knownValues() {
        EnumSet<AccountTargeting> knownValues = EnumSet.allOf(AccountTargeting.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccountTargeting.class, AccountTargeting::toString);
    }
}

