/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fis.FisClient;
import software.amazon.awssdk.services.fis.internal.UserAgentUtils;
import software.amazon.awssdk.services.fis.model.ListExperimentResolvedTargetsRequest;
import software.amazon.awssdk.services.fis.model.ListExperimentResolvedTargetsResponse;

public class ListExperimentResolvedTargetsIterable
implements SdkIterable<ListExperimentResolvedTargetsResponse> {
    private final FisClient client;
    private final ListExperimentResolvedTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExperimentResolvedTargetsIterable(FisClient client, ListExperimentResolvedTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExperimentResolvedTargetsResponseFetcher();
    }

    public Iterator<ListExperimentResolvedTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListExperimentResolvedTargetsResponseFetcher
    implements SyncPageFetcher<ListExperimentResolvedTargetsResponse> {
        private ListExperimentResolvedTargetsResponseFetcher() {
        }

        public boolean hasNextPage(ListExperimentResolvedTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExperimentResolvedTargetsResponse nextPage(ListExperimentResolvedTargetsResponse previousPage) {
            if (previousPage == null) {
                return ListExperimentResolvedTargetsIterable.this.client.listExperimentResolvedTargets(ListExperimentResolvedTargetsIterable.this.firstRequest);
            }
            return ListExperimentResolvedTargetsIterable.this.client.listExperimentResolvedTargets((ListExperimentResolvedTargetsRequest)((Object)ListExperimentResolvedTargetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

