/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateExperimentTemplateRequest extends FisRequest implements
        ToCopyableBuilder<UpdateExperimentTemplateRequest.Builder, UpdateExperimentTemplateRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateExperimentTemplateRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateExperimentTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<UpdateExperimentTemplateStopConditionInput>> STOP_CONDITIONS_FIELD = SdkField
            .<List<UpdateExperimentTemplateStopConditionInput>> builder(MarshallingType.LIST)
            .memberName("stopConditions")
            .getter(getter(UpdateExperimentTemplateRequest::stopConditions))
            .setter(setter(Builder::stopConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateExperimentTemplateStopConditionInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateExperimentTemplateStopConditionInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, UpdateExperimentTemplateTargetInput>> TARGETS_FIELD = SdkField
            .<Map<String, UpdateExperimentTemplateTargetInput>> builder(MarshallingType.MAP)
            .memberName("targets")
            .getter(getter(UpdateExperimentTemplateRequest::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<UpdateExperimentTemplateTargetInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateExperimentTemplateTargetInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, UpdateExperimentTemplateActionInputItem>> ACTIONS_FIELD = SdkField
            .<Map<String, UpdateExperimentTemplateActionInputItem>> builder(MarshallingType.MAP)
            .memberName("actions")
            .getter(getter(UpdateExperimentTemplateRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<UpdateExperimentTemplateActionInputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateExperimentTemplateActionInputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateExperimentTemplateRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD,
            STOP_CONDITIONS_FIELD, TARGETS_FIELD, ACTIONS_FIELD, ROLE_ARN_FIELD));

    private final String id;

    private final String description;

    private final List<UpdateExperimentTemplateStopConditionInput> stopConditions;

    private final Map<String, UpdateExperimentTemplateTargetInput> targets;

    private final Map<String, UpdateExperimentTemplateActionInputItem> actions;

    private final String roleArn;

    private UpdateExperimentTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.description = builder.description;
        this.stopConditions = builder.stopConditions;
        this.targets = builder.targets;
        this.actions = builder.actions;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The ID of the experiment template.
     * </p>
     * 
     * @return The ID of the experiment template.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A description for the template.
     * </p>
     * 
     * @return A description for the template.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the StopConditions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStopConditions() {
        return stopConditions != null && !(stopConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stop conditions for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStopConditions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The stop conditions for the experiment.
     */
    public final List<UpdateExperimentTemplateStopConditionInput> stopConditions() {
        return stopConditions;
    }

    /**
     * Returns true if the Targets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The targets for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The targets for the experiment.
     */
    public final Map<String, UpdateExperimentTemplateTargetInput> targets() {
        return targets;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The actions for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions for the experiment.
     */
    public final Map<String, UpdateExperimentTemplateActionInputItem> actions() {
        return actions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service
     * actions on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform
     *         service actions on your behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasStopConditions() ? stopConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExperimentTemplateRequest)) {
            return false;
        }
        UpdateExperimentTemplateRequest other = (UpdateExperimentTemplateRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(description(), other.description())
                && hasStopConditions() == other.hasStopConditions() && Objects.equals(stopConditions(), other.stopConditions())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateExperimentTemplateRequest").add("Id", id()).add("Description", description())
                .add("StopConditions", hasStopConditions() ? stopConditions() : null)
                .add("Targets", hasTargets() ? targets() : null).add("Actions", hasActions() ? actions() : null)
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "stopConditions":
            return Optional.ofNullable(clazz.cast(stopConditions()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateExperimentTemplateRequest, T> g) {
        return obj -> g.apply((UpdateExperimentTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FisRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateExperimentTemplateRequest> {
        /**
         * <p>
         * The ID of the experiment template.
         * </p>
         * 
         * @param id
         *        The ID of the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A description for the template.
         * </p>
         * 
         * @param description
         *        A description for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * 
         * @param stopConditions
         *        The stop conditions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopConditions(Collection<UpdateExperimentTemplateStopConditionInput> stopConditions);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * 
         * @param stopConditions
         *        The stop conditions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopConditions(UpdateExperimentTemplateStopConditionInput... stopConditions);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <UpdateExperimentTemplateStopConditionInput>.Builder} avoiding the need to create one manually via
         * {@link List<UpdateExperimentTemplateStopConditionInput>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpdateExperimentTemplateStopConditionInput>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #stopConditions(List<UpdateExperimentTemplateStopConditionInput>)}.
         * 
         * @param stopConditions
         *        a consumer that will call methods on {@link List<UpdateExperimentTemplateStopConditionInput>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stopConditions(List<UpdateExperimentTemplateStopConditionInput>)
         */
        Builder stopConditions(Consumer<UpdateExperimentTemplateStopConditionInput.Builder>... stopConditions);

        /**
         * <p>
         * The targets for the experiment.
         * </p>
         * 
         * @param targets
         *        The targets for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Map<String, UpdateExperimentTemplateTargetInput> targets);

        /**
         * <p>
         * The actions for the experiment.
         * </p>
         * 
         * @param actions
         *        The actions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Map<String, UpdateExperimentTemplateActionInputItem> actions);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service
         * actions on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform
         *        service actions on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FisRequest.BuilderImpl implements Builder {
        private String id;

        private String description;

        private List<UpdateExperimentTemplateStopConditionInput> stopConditions = DefaultSdkAutoConstructList.getInstance();

        private Map<String, UpdateExperimentTemplateTargetInput> targets = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, UpdateExperimentTemplateActionInputItem> actions = DefaultSdkAutoConstructMap.getInstance();

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExperimentTemplateRequest model) {
            super(model);
            id(model.id);
            description(model.description);
            stopConditions(model.stopConditions);
            targets(model.targets);
            actions(model.actions);
            roleArn(model.roleArn);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<UpdateExperimentTemplateStopConditionInput.Builder> getStopConditions() {
            List<UpdateExperimentTemplateStopConditionInput.Builder> result = UpdateExperimentTemplateStopConditionInputListCopier
                    .copyToBuilder(this.stopConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder stopConditions(Collection<UpdateExperimentTemplateStopConditionInput> stopConditions) {
            this.stopConditions = UpdateExperimentTemplateStopConditionInputListCopier.copy(stopConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(UpdateExperimentTemplateStopConditionInput... stopConditions) {
            stopConditions(Arrays.asList(stopConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(Consumer<UpdateExperimentTemplateStopConditionInput.Builder>... stopConditions) {
            stopConditions(Stream.of(stopConditions)
                    .map(c -> UpdateExperimentTemplateStopConditionInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStopConditions(Collection<UpdateExperimentTemplateStopConditionInput.BuilderImpl> stopConditions) {
            this.stopConditions = UpdateExperimentTemplateStopConditionInputListCopier.copyFromBuilder(stopConditions);
        }

        public final Map<String, UpdateExperimentTemplateTargetInput.Builder> getTargets() {
            Map<String, UpdateExperimentTemplateTargetInput.Builder> result = UpdateExperimentTemplateTargetInputMapCopier
                    .copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder targets(Map<String, UpdateExperimentTemplateTargetInput> targets) {
            this.targets = UpdateExperimentTemplateTargetInputMapCopier.copy(targets);
            return this;
        }

        public final void setTargets(Map<String, UpdateExperimentTemplateTargetInput.BuilderImpl> targets) {
            this.targets = UpdateExperimentTemplateTargetInputMapCopier.copyFromBuilder(targets);
        }

        public final Map<String, UpdateExperimentTemplateActionInputItem.Builder> getActions() {
            Map<String, UpdateExperimentTemplateActionInputItem.Builder> result = UpdateExperimentTemplateActionInputMapCopier
                    .copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder actions(Map<String, UpdateExperimentTemplateActionInputItem> actions) {
            this.actions = UpdateExperimentTemplateActionInputMapCopier.copy(actions);
            return this;
        }

        public final void setActions(Map<String, UpdateExperimentTemplateActionInputItem.BuilderImpl> actions) {
            this.actions = UpdateExperimentTemplateActionInputMapCopier.copyFromBuilder(actions);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateExperimentTemplateRequest build() {
            return new UpdateExperimentTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
