/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a target for an experiment template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentTemplateTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentTemplateTarget.Builder, ExperimentTemplateTarget> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ExperimentTemplateTarget::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceArns")
            .getter(getter(ExperimentTemplateTarget::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RESOURCE_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("resourceTags")
            .getter(getter(ExperimentTemplateTarget::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ExperimentTemplateTargetFilter>> FILTERS_FIELD = SdkField
            .<List<ExperimentTemplateTargetFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ExperimentTemplateTarget::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExperimentTemplateTargetFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentTemplateTargetFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SELECTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("selectionMode").getter(getter(ExperimentTemplateTarget::selectionMode))
            .setter(setter(Builder::selectionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            RESOURCE_ARNS_FIELD, RESOURCE_TAGS_FIELD, FILTERS_FIELD, SELECTION_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final List<String> resourceArns;

    private final Map<String, String> resourceTags;

    private final List<ExperimentTemplateTargetFilter> filters;

    private final String selectionMode;

    private ExperimentTemplateTarget(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceArns = builder.resourceArns;
        this.resourceTags = builder.resourceTags;
        this.filters = builder.filters;
        this.selectionMode = builder.selectionMode;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * 
     * @return The resource type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * Returns true if the ResourceArns property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the targets.
     */
    public final List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * Returns true if the ResourceTags property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the target resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags for the target resources.
     */
    public final Map<String, String> resourceTags() {
        return resourceTags;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters to apply to identify target resources using specific attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filters to apply to identify target resources using specific attributes.
     */
    public final List<ExperimentTemplateTargetFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * Scopes the identified resources to a specific count or percentage.
     * </p>
     * 
     * @return Scopes the identified resources to a specific count or percentage.
     */
    public final String selectionMode() {
        return selectionMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArns() ? resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(selectionMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentTemplateTarget)) {
            return false;
        }
        ExperimentTemplateTarget other = (ExperimentTemplateTarget) obj;
        return Objects.equals(resourceType(), other.resourceType()) && hasResourceArns() == other.hasResourceArns()
                && Objects.equals(resourceArns(), other.resourceArns()) && hasResourceTags() == other.hasResourceTags()
                && Objects.equals(resourceTags(), other.resourceTags()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(selectionMode(), other.selectionMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentTemplateTarget").add("ResourceType", resourceType())
                .add("ResourceArns", hasResourceArns() ? resourceArns() : null)
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null).add("Filters", hasFilters() ? filters() : null)
                .add("SelectionMode", selectionMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "resourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "resourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "selectionMode":
            return Optional.ofNullable(clazz.cast(selectionMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentTemplateTarget, T> g) {
        return obj -> g.apply((ExperimentTemplateTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentTemplateTarget> {
        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the targets.
         * </p>
         * 
         * @param resourceArns
         *        The Amazon Resource Names (ARNs) of the targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the targets.
         * </p>
         * 
         * @param resourceArns
         *        The Amazon Resource Names (ARNs) of the targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * The tags for the target resources.
         * </p>
         * 
         * @param resourceTags
         *        The tags for the target resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Map<String, String> resourceTags);

        /**
         * <p>
         * The filters to apply to identify target resources using specific attributes.
         * </p>
         * 
         * @param filters
         *        The filters to apply to identify target resources using specific attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ExperimentTemplateTargetFilter> filters);

        /**
         * <p>
         * The filters to apply to identify target resources using specific attributes.
         * </p>
         * 
         * @param filters
         *        The filters to apply to identify target resources using specific attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ExperimentTemplateTargetFilter... filters);

        /**
         * <p>
         * The filters to apply to identify target resources using specific attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExperimentTemplateTargetFilter>.Builder}
         * avoiding the need to create one manually via {@link List<ExperimentTemplateTargetFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExperimentTemplateTargetFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<ExperimentTemplateTargetFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ExperimentTemplateTargetFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ExperimentTemplateTargetFilter>)
         */
        Builder filters(Consumer<ExperimentTemplateTargetFilter.Builder>... filters);

        /**
         * <p>
         * Scopes the identified resources to a specific count or percentage.
         * </p>
         * 
         * @param selectionMode
         *        Scopes the identified resources to a specific count or percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionMode(String selectionMode);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> resourceTags = DefaultSdkAutoConstructMap.getInstance();

        private List<ExperimentTemplateTargetFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String selectionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentTemplateTarget model) {
            resourceType(model.resourceType);
            resourceArns(model.resourceArns);
            resourceTags(model.resourceTags);
            filters(model.filters);
            selectionMode(model.selectionMode);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getResourceArns() {
            if (resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
        }

        public final Map<String, String> getResourceTags() {
            if (resourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return resourceTags;
        }

        @Override
        public final Builder resourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagMapCopier.copy(resourceTags);
            return this;
        }

        public final void setResourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagMapCopier.copy(resourceTags);
        }

        public final List<ExperimentTemplateTargetFilter.Builder> getFilters() {
            List<ExperimentTemplateTargetFilter.Builder> result = ExperimentTemplateTargetFilterListCopier
                    .copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<ExperimentTemplateTargetFilter> filters) {
            this.filters = ExperimentTemplateTargetFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ExperimentTemplateTargetFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ExperimentTemplateTargetFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ExperimentTemplateTargetFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ExperimentTemplateTargetFilter.BuilderImpl> filters) {
            this.filters = ExperimentTemplateTargetFilterListCopier.copyFromBuilder(filters);
        }

        public final String getSelectionMode() {
            return selectionMode;
        }

        @Override
        public final Builder selectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
            return this;
        }

        public final void setSelectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
        }

        @Override
        public ExperimentTemplateTarget build() {
            return new ExperimentTemplateTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
