/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ParquetCompression {
    UNCOMPRESSED("UNCOMPRESSED"),
    GZIP("GZIP"),
    SNAPPY("SNAPPY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParquetCompression> VALUE_MAP;
    private final String value;

    private ParquetCompression(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParquetCompression fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParquetCompression> knownValues() {
        EnumSet<ParquetCompression> knownValues = EnumSet.allOf(ParquetCompression.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ParquetCompression.class, ParquetCompression::toString);
    }
}

