/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.DatabaseSourceDescription;
import software.amazon.awssdk.services.firehose.model.KinesisStreamSourceDescription;
import software.amazon.awssdk.services.firehose.model.MSKSourceDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceDescription> {
    private static final SdkField<KinesisStreamSourceDescription> KINESIS_STREAM_SOURCE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisStreamSourceDescription").getter(SourceDescription.getter(SourceDescription::kinesisStreamSourceDescription)).setter(SourceDescription.setter(Builder::kinesisStreamSourceDescription)).constructor(KinesisStreamSourceDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamSourceDescription").build()}).build();
    private static final SdkField<MSKSourceDescription> MSK_SOURCE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MSKSourceDescription").getter(SourceDescription.getter(SourceDescription::mskSourceDescription)).setter(SourceDescription.setter(Builder::mskSourceDescription)).constructor(MSKSourceDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MSKSourceDescription").build()}).build();
    private static final SdkField<DatabaseSourceDescription> DATABASE_SOURCE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatabaseSourceDescription").getter(SourceDescription.getter(SourceDescription::databaseSourceDescription)).setter(SourceDescription.setter(Builder::databaseSourceDescription)).constructor(DatabaseSourceDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseSourceDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KINESIS_STREAM_SOURCE_DESCRIPTION_FIELD, MSK_SOURCE_DESCRIPTION_FIELD, DATABASE_SOURCE_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final KinesisStreamSourceDescription kinesisStreamSourceDescription;
    private final MSKSourceDescription mskSourceDescription;
    private final DatabaseSourceDescription databaseSourceDescription;

    private SourceDescription(BuilderImpl builder) {
        this.kinesisStreamSourceDescription = builder.kinesisStreamSourceDescription;
        this.mskSourceDescription = builder.mskSourceDescription;
        this.databaseSourceDescription = builder.databaseSourceDescription;
    }

    public final KinesisStreamSourceDescription kinesisStreamSourceDescription() {
        return this.kinesisStreamSourceDescription;
    }

    public final MSKSourceDescription mskSourceDescription() {
        return this.mskSourceDescription;
    }

    public final DatabaseSourceDescription databaseSourceDescription() {
        return this.databaseSourceDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamSourceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.mskSourceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseSourceDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDescription)) {
            return false;
        }
        SourceDescription other = (SourceDescription)obj;
        return Objects.equals(this.kinesisStreamSourceDescription(), other.kinesisStreamSourceDescription()) && Objects.equals(this.mskSourceDescription(), other.mskSourceDescription()) && Objects.equals(this.databaseSourceDescription(), other.databaseSourceDescription());
    }

    public final String toString() {
        return ToString.builder((String)"SourceDescription").add("KinesisStreamSourceDescription", (Object)this.kinesisStreamSourceDescription()).add("MSKSourceDescription", (Object)this.mskSourceDescription()).add("DatabaseSourceDescription", (Object)this.databaseSourceDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KinesisStreamSourceDescription": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamSourceDescription()));
            }
            case "MSKSourceDescription": {
                return Optional.ofNullable(clazz.cast(this.mskSourceDescription()));
            }
            case "DatabaseSourceDescription": {
                return Optional.ofNullable(clazz.cast(this.databaseSourceDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KinesisStreamSourceDescription", KINESIS_STREAM_SOURCE_DESCRIPTION_FIELD);
        map.put("MSKSourceDescription", MSK_SOURCE_DESCRIPTION_FIELD);
        map.put("DatabaseSourceDescription", DATABASE_SOURCE_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceDescription, T> g) {
        return obj -> g.apply((SourceDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private KinesisStreamSourceDescription kinesisStreamSourceDescription;
        private MSKSourceDescription mskSourceDescription;
        private DatabaseSourceDescription databaseSourceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDescription model) {
            this.kinesisStreamSourceDescription(model.kinesisStreamSourceDescription);
            this.mskSourceDescription(model.mskSourceDescription);
            this.databaseSourceDescription(model.databaseSourceDescription);
        }

        public final KinesisStreamSourceDescription.Builder getKinesisStreamSourceDescription() {
            return this.kinesisStreamSourceDescription != null ? this.kinesisStreamSourceDescription.toBuilder() : null;
        }

        public final void setKinesisStreamSourceDescription(KinesisStreamSourceDescription.BuilderImpl kinesisStreamSourceDescription) {
            this.kinesisStreamSourceDescription = kinesisStreamSourceDescription != null ? kinesisStreamSourceDescription.build() : null;
        }

        @Override
        public final Builder kinesisStreamSourceDescription(KinesisStreamSourceDescription kinesisStreamSourceDescription) {
            this.kinesisStreamSourceDescription = kinesisStreamSourceDescription;
            return this;
        }

        public final MSKSourceDescription.Builder getMskSourceDescription() {
            return this.mskSourceDescription != null ? this.mskSourceDescription.toBuilder() : null;
        }

        public final void setMskSourceDescription(MSKSourceDescription.BuilderImpl mskSourceDescription) {
            this.mskSourceDescription = mskSourceDescription != null ? mskSourceDescription.build() : null;
        }

        @Override
        public final Builder mskSourceDescription(MSKSourceDescription mskSourceDescription) {
            this.mskSourceDescription = mskSourceDescription;
            return this;
        }

        public final DatabaseSourceDescription.Builder getDatabaseSourceDescription() {
            return this.databaseSourceDescription != null ? this.databaseSourceDescription.toBuilder() : null;
        }

        public final void setDatabaseSourceDescription(DatabaseSourceDescription.BuilderImpl databaseSourceDescription) {
            this.databaseSourceDescription = databaseSourceDescription != null ? databaseSourceDescription.build() : null;
        }

        @Override
        public final Builder databaseSourceDescription(DatabaseSourceDescription databaseSourceDescription) {
            this.databaseSourceDescription = databaseSourceDescription;
            return this;
        }

        public SourceDescription build() {
            return new SourceDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceDescription> {
        public Builder kinesisStreamSourceDescription(KinesisStreamSourceDescription var1);

        default public Builder kinesisStreamSourceDescription(Consumer<KinesisStreamSourceDescription.Builder> kinesisStreamSourceDescription) {
            return this.kinesisStreamSourceDescription((KinesisStreamSourceDescription)((KinesisStreamSourceDescription.Builder)KinesisStreamSourceDescription.builder().applyMutation(kinesisStreamSourceDescription)).build());
        }

        public Builder mskSourceDescription(MSKSourceDescription var1);

        default public Builder mskSourceDescription(Consumer<MSKSourceDescription.Builder> mskSourceDescription) {
            return this.mskSourceDescription((MSKSourceDescription)((MSKSourceDescription.Builder)MSKSourceDescription.builder().applyMutation(mskSourceDescription)).build());
        }

        public Builder databaseSourceDescription(DatabaseSourceDescription var1);

        default public Builder databaseSourceDescription(Consumer<DatabaseSourceDescription.Builder> databaseSourceDescription) {
            return this.databaseSourceDescription((DatabaseSourceDescription)((DatabaseSourceDescription.Builder)DatabaseSourceDescription.builder().applyMutation(databaseSourceDescription)).build());
        }
    }
}

