/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a Kinesis data stream used as the source for a Firehose Firehose stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceDescription.Builder, SourceDescription> {
    private static final SdkField<KinesisStreamSourceDescription> KINESIS_STREAM_SOURCE_DESCRIPTION_FIELD = SdkField
            .<KinesisStreamSourceDescription> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisStreamSourceDescription")
            .getter(getter(SourceDescription::kinesisStreamSourceDescription))
            .setter(setter(Builder::kinesisStreamSourceDescription))
            .constructor(KinesisStreamSourceDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamSourceDescription")
                    .build()).build();

    private static final SdkField<MSKSourceDescription> MSK_SOURCE_DESCRIPTION_FIELD = SdkField
            .<MSKSourceDescription> builder(MarshallingType.SDK_POJO).memberName("MSKSourceDescription")
            .getter(getter(SourceDescription::mskSourceDescription)).setter(setter(Builder::mskSourceDescription))
            .constructor(MSKSourceDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MSKSourceDescription").build())
            .build();

    private static final SdkField<DatabaseSourceDescription> DATABASE_SOURCE_DESCRIPTION_FIELD = SdkField
            .<DatabaseSourceDescription> builder(MarshallingType.SDK_POJO).memberName("DatabaseSourceDescription")
            .getter(getter(SourceDescription::databaseSourceDescription)).setter(setter(Builder::databaseSourceDescription))
            .constructor(DatabaseSourceDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseSourceDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            KINESIS_STREAM_SOURCE_DESCRIPTION_FIELD, MSK_SOURCE_DESCRIPTION_FIELD, DATABASE_SOURCE_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KinesisStreamSourceDescription kinesisStreamSourceDescription;

    private final MSKSourceDescription mskSourceDescription;

    private final DatabaseSourceDescription databaseSourceDescription;

    private SourceDescription(BuilderImpl builder) {
        this.kinesisStreamSourceDescription = builder.kinesisStreamSourceDescription;
        this.mskSourceDescription = builder.mskSourceDescription;
        this.databaseSourceDescription = builder.databaseSourceDescription;
    }

    /**
     * <p>
     * The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
     * </p>
     * 
     * @return The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
     */
    public final KinesisStreamSourceDescription kinesisStreamSourceDescription() {
        return kinesisStreamSourceDescription;
    }

    /**
     * <p>
     * The configuration description for the Amazon MSK cluster to be used as the source for a delivery stream.
     * </p>
     * 
     * @return The configuration description for the Amazon MSK cluster to be used as the source for a delivery stream.
     */
    public final MSKSourceDescription mskSourceDescription() {
        return mskSourceDescription;
    }

    /**
     * <p>
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * 
     * @return </p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     */
    public final DatabaseSourceDescription databaseSourceDescription() {
        return databaseSourceDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamSourceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(mskSourceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(databaseSourceDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDescription)) {
            return false;
        }
        SourceDescription other = (SourceDescription) obj;
        return Objects.equals(kinesisStreamSourceDescription(), other.kinesisStreamSourceDescription())
                && Objects.equals(mskSourceDescription(), other.mskSourceDescription())
                && Objects.equals(databaseSourceDescription(), other.databaseSourceDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceDescription").add("KinesisStreamSourceDescription", kinesisStreamSourceDescription())
                .add("MSKSourceDescription", mskSourceDescription())
                .add("DatabaseSourceDescription", databaseSourceDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KinesisStreamSourceDescription":
            return Optional.ofNullable(clazz.cast(kinesisStreamSourceDescription()));
        case "MSKSourceDescription":
            return Optional.ofNullable(clazz.cast(mskSourceDescription()));
        case "DatabaseSourceDescription":
            return Optional.ofNullable(clazz.cast(databaseSourceDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KinesisStreamSourceDescription", KINESIS_STREAM_SOURCE_DESCRIPTION_FIELD);
        map.put("MSKSourceDescription", MSK_SOURCE_DESCRIPTION_FIELD);
        map.put("DatabaseSourceDescription", DATABASE_SOURCE_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceDescription, T> g) {
        return obj -> g.apply((SourceDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceDescription> {
        /**
         * <p>
         * The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
         * </p>
         * 
         * @param kinesisStreamSourceDescription
         *        The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamSourceDescription(KinesisStreamSourceDescription kinesisStreamSourceDescription);

        /**
         * <p>
         * The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisStreamSourceDescription.Builder}
         * avoiding the need to create one manually via {@link KinesisStreamSourceDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisStreamSourceDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisStreamSourceDescription(KinesisStreamSourceDescription)}.
         * 
         * @param kinesisStreamSourceDescription
         *        a consumer that will call methods on {@link KinesisStreamSourceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamSourceDescription(KinesisStreamSourceDescription)
         */
        default Builder kinesisStreamSourceDescription(
                Consumer<KinesisStreamSourceDescription.Builder> kinesisStreamSourceDescription) {
            return kinesisStreamSourceDescription(KinesisStreamSourceDescription.builder()
                    .applyMutation(kinesisStreamSourceDescription).build());
        }

        /**
         * <p>
         * The configuration description for the Amazon MSK cluster to be used as the source for a delivery stream.
         * </p>
         * 
         * @param mskSourceDescription
         *        The configuration description for the Amazon MSK cluster to be used as the source for a delivery
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mskSourceDescription(MSKSourceDescription mskSourceDescription);

        /**
         * <p>
         * The configuration description for the Amazon MSK cluster to be used as the source for a delivery stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link MSKSourceDescription.Builder} avoiding
         * the need to create one manually via {@link MSKSourceDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MSKSourceDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #mskSourceDescription(MSKSourceDescription)}.
         * 
         * @param mskSourceDescription
         *        a consumer that will call methods on {@link MSKSourceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mskSourceDescription(MSKSourceDescription)
         */
        default Builder mskSourceDescription(Consumer<MSKSourceDescription.Builder> mskSourceDescription) {
            return mskSourceDescription(MSKSourceDescription.builder().applyMutation(mskSourceDescription).build());
        }

        /**
         * <p>
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param databaseSourceDescription
         *        </p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseSourceDescription(DatabaseSourceDescription databaseSourceDescription);

        /**
         * <p>
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatabaseSourceDescription.Builder}
         * avoiding the need to create one manually via {@link DatabaseSourceDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatabaseSourceDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #databaseSourceDescription(DatabaseSourceDescription)}.
         * 
         * @param databaseSourceDescription
         *        a consumer that will call methods on {@link DatabaseSourceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databaseSourceDescription(DatabaseSourceDescription)
         */
        default Builder databaseSourceDescription(Consumer<DatabaseSourceDescription.Builder> databaseSourceDescription) {
            return databaseSourceDescription(DatabaseSourceDescription.builder().applyMutation(databaseSourceDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KinesisStreamSourceDescription kinesisStreamSourceDescription;

        private MSKSourceDescription mskSourceDescription;

        private DatabaseSourceDescription databaseSourceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDescription model) {
            kinesisStreamSourceDescription(model.kinesisStreamSourceDescription);
            mskSourceDescription(model.mskSourceDescription);
            databaseSourceDescription(model.databaseSourceDescription);
        }

        public final KinesisStreamSourceDescription.Builder getKinesisStreamSourceDescription() {
            return kinesisStreamSourceDescription != null ? kinesisStreamSourceDescription.toBuilder() : null;
        }

        public final void setKinesisStreamSourceDescription(
                KinesisStreamSourceDescription.BuilderImpl kinesisStreamSourceDescription) {
            this.kinesisStreamSourceDescription = kinesisStreamSourceDescription != null ? kinesisStreamSourceDescription.build()
                    : null;
        }

        @Override
        public final Builder kinesisStreamSourceDescription(KinesisStreamSourceDescription kinesisStreamSourceDescription) {
            this.kinesisStreamSourceDescription = kinesisStreamSourceDescription;
            return this;
        }

        public final MSKSourceDescription.Builder getMskSourceDescription() {
            return mskSourceDescription != null ? mskSourceDescription.toBuilder() : null;
        }

        public final void setMskSourceDescription(MSKSourceDescription.BuilderImpl mskSourceDescription) {
            this.mskSourceDescription = mskSourceDescription != null ? mskSourceDescription.build() : null;
        }

        @Override
        public final Builder mskSourceDescription(MSKSourceDescription mskSourceDescription) {
            this.mskSourceDescription = mskSourceDescription;
            return this;
        }

        public final DatabaseSourceDescription.Builder getDatabaseSourceDescription() {
            return databaseSourceDescription != null ? databaseSourceDescription.toBuilder() : null;
        }

        public final void setDatabaseSourceDescription(DatabaseSourceDescription.BuilderImpl databaseSourceDescription) {
            this.databaseSourceDescription = databaseSourceDescription != null ? databaseSourceDescription.build() : null;
        }

        @Override
        public final Builder databaseSourceDescription(DatabaseSourceDescription databaseSourceDescription) {
            this.databaseSourceDescription = databaseSourceDescription;
            return this;
        }

        @Override
        public SourceDescription build() {
            return new SourceDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
