/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a destination in Apache Iceberg Tables.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationTableConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationTableConfiguration.Builder, DestinationTableConfiguration> {
    private static final SdkField<String> DESTINATION_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationTableName").getter(getter(DestinationTableConfiguration::destinationTableName))
            .setter(setter(Builder::destinationTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTableName").build())
            .build();

    private static final SdkField<String> DESTINATION_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationDatabaseName").getter(getter(DestinationTableConfiguration::destinationDatabaseName))
            .setter(setter(Builder::destinationDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDatabaseName").build())
            .build();

    private static final SdkField<List<String>> UNIQUE_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UniqueKeys")
            .getter(getter(DestinationTableConfiguration::uniqueKeys))
            .setter(setter(Builder::uniqueKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PartitionSpec> PARTITION_SPEC_FIELD = SdkField
            .<PartitionSpec> builder(MarshallingType.SDK_POJO).memberName("PartitionSpec")
            .getter(getter(DestinationTableConfiguration::partitionSpec)).setter(setter(Builder::partitionSpec))
            .constructor(PartitionSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionSpec").build()).build();

    private static final SdkField<String> S3_ERROR_OUTPUT_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3ErrorOutputPrefix").getter(getter(DestinationTableConfiguration::s3ErrorOutputPrefix))
            .setter(setter(Builder::s3ErrorOutputPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ErrorOutputPrefix").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_TABLE_NAME_FIELD,
            DESTINATION_DATABASE_NAME_FIELD, UNIQUE_KEYS_FIELD, PARTITION_SPEC_FIELD, S3_ERROR_OUTPUT_PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationTableName;

    private final String destinationDatabaseName;

    private final List<String> uniqueKeys;

    private final PartitionSpec partitionSpec;

    private final String s3ErrorOutputPrefix;

    private DestinationTableConfiguration(BuilderImpl builder) {
        this.destinationTableName = builder.destinationTableName;
        this.destinationDatabaseName = builder.destinationDatabaseName;
        this.uniqueKeys = builder.uniqueKeys;
        this.partitionSpec = builder.partitionSpec;
        this.s3ErrorOutputPrefix = builder.s3ErrorOutputPrefix;
    }

    /**
     * <p>
     * Specifies the name of the Apache Iceberg Table.
     * </p>
     * 
     * @return Specifies the name of the Apache Iceberg Table.
     */
    public final String destinationTableName() {
        return destinationTableName;
    }

    /**
     * <p>
     * The name of the Apache Iceberg database.
     * </p>
     * 
     * @return The name of the Apache Iceberg database.
     */
    public final String destinationDatabaseName() {
        return destinationDatabaseName;
    }

    /**
     * For responses, this returns true if the service returned a value for the UniqueKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUniqueKeys() {
        return uniqueKeys != null && !(uniqueKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unique keys for a given Apache Iceberg table. Firehose will use these for running Create, Update, or
     * Delete operations on the given Iceberg table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUniqueKeys} method.
     * </p>
     * 
     * @return A list of unique keys for a given Apache Iceberg table. Firehose will use these for running Create,
     *         Update, or Delete operations on the given Iceberg table.
     */
    public final List<String> uniqueKeys() {
        return uniqueKeys;
    }

    /**
     * <p>
     * </p>
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * </p>
     * 
     * @return </p>
     *         <p>
     *         Amazon Data Firehose is in preview release and is subject to change.
     */
    public final PartitionSpec partitionSpec() {
        return partitionSpec;
    }

    /**
     * <p>
     * The table specific S3 error output prefix. All the errors that occurred while delivering to this table will be
     * prefixed with this value in S3 destination.
     * </p>
     * 
     * @return The table specific S3 error output prefix. All the errors that occurred while delivering to this table
     *         will be prefixed with this value in S3 destination.
     */
    public final String s3ErrorOutputPrefix() {
        return s3ErrorOutputPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationTableName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(hasUniqueKeys() ? uniqueKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(partitionSpec());
        hashCode = 31 * hashCode + Objects.hashCode(s3ErrorOutputPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationTableConfiguration)) {
            return false;
        }
        DestinationTableConfiguration other = (DestinationTableConfiguration) obj;
        return Objects.equals(destinationTableName(), other.destinationTableName())
                && Objects.equals(destinationDatabaseName(), other.destinationDatabaseName())
                && hasUniqueKeys() == other.hasUniqueKeys() && Objects.equals(uniqueKeys(), other.uniqueKeys())
                && Objects.equals(partitionSpec(), other.partitionSpec())
                && Objects.equals(s3ErrorOutputPrefix(), other.s3ErrorOutputPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationTableConfiguration").add("DestinationTableName", destinationTableName())
                .add("DestinationDatabaseName", destinationDatabaseName())
                .add("UniqueKeys", hasUniqueKeys() ? uniqueKeys() : null).add("PartitionSpec", partitionSpec())
                .add("S3ErrorOutputPrefix", s3ErrorOutputPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationTableName":
            return Optional.ofNullable(clazz.cast(destinationTableName()));
        case "DestinationDatabaseName":
            return Optional.ofNullable(clazz.cast(destinationDatabaseName()));
        case "UniqueKeys":
            return Optional.ofNullable(clazz.cast(uniqueKeys()));
        case "PartitionSpec":
            return Optional.ofNullable(clazz.cast(partitionSpec()));
        case "S3ErrorOutputPrefix":
            return Optional.ofNullable(clazz.cast(s3ErrorOutputPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationTableName", DESTINATION_TABLE_NAME_FIELD);
        map.put("DestinationDatabaseName", DESTINATION_DATABASE_NAME_FIELD);
        map.put("UniqueKeys", UNIQUE_KEYS_FIELD);
        map.put("PartitionSpec", PARTITION_SPEC_FIELD);
        map.put("S3ErrorOutputPrefix", S3_ERROR_OUTPUT_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationTableConfiguration, T> g) {
        return obj -> g.apply((DestinationTableConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationTableConfiguration> {
        /**
         * <p>
         * Specifies the name of the Apache Iceberg Table.
         * </p>
         * 
         * @param destinationTableName
         *        Specifies the name of the Apache Iceberg Table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTableName(String destinationTableName);

        /**
         * <p>
         * The name of the Apache Iceberg database.
         * </p>
         * 
         * @param destinationDatabaseName
         *        The name of the Apache Iceberg database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationDatabaseName(String destinationDatabaseName);

        /**
         * <p>
         * A list of unique keys for a given Apache Iceberg table. Firehose will use these for running Create, Update,
         * or Delete operations on the given Iceberg table.
         * </p>
         * 
         * @param uniqueKeys
         *        A list of unique keys for a given Apache Iceberg table. Firehose will use these for running Create,
         *        Update, or Delete operations on the given Iceberg table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueKeys(Collection<String> uniqueKeys);

        /**
         * <p>
         * A list of unique keys for a given Apache Iceberg table. Firehose will use these for running Create, Update,
         * or Delete operations on the given Iceberg table.
         * </p>
         * 
         * @param uniqueKeys
         *        A list of unique keys for a given Apache Iceberg table. Firehose will use these for running Create,
         *        Update, or Delete operations on the given Iceberg table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueKeys(String... uniqueKeys);

        /**
         * <p>
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * 
         * @param partitionSpec
         *        </p>
         *        <p>
         *        Amazon Data Firehose is in preview release and is subject to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionSpec(PartitionSpec partitionSpec);

        /**
         * <p>
         * </p>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * </p>
         * This is a convenience method that creates an instance of the {@link PartitionSpec.Builder} avoiding the need
         * to create one manually via {@link PartitionSpec#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PartitionSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #partitionSpec(PartitionSpec)}.
         * 
         * @param partitionSpec
         *        a consumer that will call methods on {@link PartitionSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionSpec(PartitionSpec)
         */
        default Builder partitionSpec(Consumer<PartitionSpec.Builder> partitionSpec) {
            return partitionSpec(PartitionSpec.builder().applyMutation(partitionSpec).build());
        }

        /**
         * <p>
         * The table specific S3 error output prefix. All the errors that occurred while delivering to this table will
         * be prefixed with this value in S3 destination.
         * </p>
         * 
         * @param s3ErrorOutputPrefix
         *        The table specific S3 error output prefix. All the errors that occurred while delivering to this table
         *        will be prefixed with this value in S3 destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ErrorOutputPrefix(String s3ErrorOutputPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String destinationTableName;

        private String destinationDatabaseName;

        private List<String> uniqueKeys = DefaultSdkAutoConstructList.getInstance();

        private PartitionSpec partitionSpec;

        private String s3ErrorOutputPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationTableConfiguration model) {
            destinationTableName(model.destinationTableName);
            destinationDatabaseName(model.destinationDatabaseName);
            uniqueKeys(model.uniqueKeys);
            partitionSpec(model.partitionSpec);
            s3ErrorOutputPrefix(model.s3ErrorOutputPrefix);
        }

        public final String getDestinationTableName() {
            return destinationTableName;
        }

        public final void setDestinationTableName(String destinationTableName) {
            this.destinationTableName = destinationTableName;
        }

        @Override
        public final Builder destinationTableName(String destinationTableName) {
            this.destinationTableName = destinationTableName;
            return this;
        }

        public final String getDestinationDatabaseName() {
            return destinationDatabaseName;
        }

        public final void setDestinationDatabaseName(String destinationDatabaseName) {
            this.destinationDatabaseName = destinationDatabaseName;
        }

        @Override
        public final Builder destinationDatabaseName(String destinationDatabaseName) {
            this.destinationDatabaseName = destinationDatabaseName;
            return this;
        }

        public final Collection<String> getUniqueKeys() {
            if (uniqueKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return uniqueKeys;
        }

        public final void setUniqueKeys(Collection<String> uniqueKeys) {
            this.uniqueKeys = ListOfNonEmptyStringsWithoutWhitespaceCopier.copy(uniqueKeys);
        }

        @Override
        public final Builder uniqueKeys(Collection<String> uniqueKeys) {
            this.uniqueKeys = ListOfNonEmptyStringsWithoutWhitespaceCopier.copy(uniqueKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uniqueKeys(String... uniqueKeys) {
            uniqueKeys(Arrays.asList(uniqueKeys));
            return this;
        }

        public final PartitionSpec.Builder getPartitionSpec() {
            return partitionSpec != null ? partitionSpec.toBuilder() : null;
        }

        public final void setPartitionSpec(PartitionSpec.BuilderImpl partitionSpec) {
            this.partitionSpec = partitionSpec != null ? partitionSpec.build() : null;
        }

        @Override
        public final Builder partitionSpec(PartitionSpec partitionSpec) {
            this.partitionSpec = partitionSpec;
            return this;
        }

        public final String getS3ErrorOutputPrefix() {
            return s3ErrorOutputPrefix;
        }

        public final void setS3ErrorOutputPrefix(String s3ErrorOutputPrefix) {
            this.s3ErrorOutputPrefix = s3ErrorOutputPrefix;
        }

        @Override
        public final Builder s3ErrorOutputPrefix(String s3ErrorOutputPrefix) {
            this.s3ErrorOutputPrefix = s3ErrorOutputPrefix;
            return this;
        }

        @Override
        public DestinationTableConfiguration build() {
            return new DestinationTableConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
