/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.FirehoseResponse;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntry;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponseEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRecordBatchResponse
extends FirehoseResponse
implements ToCopyableBuilder<Builder, PutRecordBatchResponse> {
    private static final SdkField<Integer> FAILED_PUT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedPutCount").getter(PutRecordBatchResponse.getter(PutRecordBatchResponse::failedPutCount)).setter(PutRecordBatchResponse.setter(Builder::failedPutCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedPutCount").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(PutRecordBatchResponse.getter(PutRecordBatchResponse::encrypted)).setter(PutRecordBatchResponse.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<List<PutRecordBatchResponseEntry>> REQUEST_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequestResponses").getter(PutRecordBatchResponse.getter(PutRecordBatchResponse::requestResponses)).setter(PutRecordBatchResponse.setter(Builder::requestResponses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestResponses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PutRecordBatchResponseEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_PUT_COUNT_FIELD, ENCRYPTED_FIELD, REQUEST_RESPONSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRecordBatchResponse.memberNameToFieldInitializer();
    private final Integer failedPutCount;
    private final Boolean encrypted;
    private final List<PutRecordBatchResponseEntry> requestResponses;

    private PutRecordBatchResponse(BuilderImpl builder) {
        super(builder);
        this.failedPutCount = builder.failedPutCount;
        this.encrypted = builder.encrypted;
        this.requestResponses = builder.requestResponses;
    }

    public final Integer failedPutCount() {
        return this.failedPutCount;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final boolean hasRequestResponses() {
        return this.requestResponses != null && !(this.requestResponses instanceof SdkAutoConstructList);
    }

    public final List<PutRecordBatchResponseEntry> requestResponses() {
        return this.requestResponses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.failedPutCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestResponses() ? this.requestResponses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordBatchResponse)) {
            return false;
        }
        PutRecordBatchResponse other = (PutRecordBatchResponse)((Object)obj);
        return Objects.equals(this.failedPutCount(), other.failedPutCount()) && Objects.equals(this.encrypted(), other.encrypted()) && this.hasRequestResponses() == other.hasRequestResponses() && Objects.equals(this.requestResponses(), other.requestResponses());
    }

    public final String toString() {
        return ToString.builder((String)"PutRecordBatchResponse").add("FailedPutCount", (Object)this.failedPutCount()).add("Encrypted", (Object)this.encrypted()).add("RequestResponses", this.hasRequestResponses() ? this.requestResponses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedPutCount": {
                return Optional.ofNullable(clazz.cast(this.failedPutCount()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "RequestResponses": {
                return Optional.ofNullable(clazz.cast(this.requestResponses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FailedPutCount", FAILED_PUT_COUNT_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("RequestResponses", REQUEST_RESPONSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRecordBatchResponse, T> g) {
        return obj -> g.apply((PutRecordBatchResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseResponse.BuilderImpl
    implements Builder {
        private Integer failedPutCount;
        private Boolean encrypted;
        private List<PutRecordBatchResponseEntry> requestResponses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordBatchResponse model) {
            super(model);
            this.failedPutCount(model.failedPutCount);
            this.encrypted(model.encrypted);
            this.requestResponses(model.requestResponses);
        }

        public final Integer getFailedPutCount() {
            return this.failedPutCount;
        }

        public final void setFailedPutCount(Integer failedPutCount) {
            this.failedPutCount = failedPutCount;
        }

        @Override
        public final Builder failedPutCount(Integer failedPutCount) {
            this.failedPutCount = failedPutCount;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final List<PutRecordBatchResponseEntry.Builder> getRequestResponses() {
            List<PutRecordBatchResponseEntry.Builder> result = PutRecordBatchResponseEntryListCopier.copyToBuilder(this.requestResponses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequestResponses(Collection<PutRecordBatchResponseEntry.BuilderImpl> requestResponses) {
            this.requestResponses = PutRecordBatchResponseEntryListCopier.copyFromBuilder(requestResponses);
        }

        @Override
        public final Builder requestResponses(Collection<PutRecordBatchResponseEntry> requestResponses) {
            this.requestResponses = PutRecordBatchResponseEntryListCopier.copy(requestResponses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestResponses(PutRecordBatchResponseEntry ... requestResponses) {
            this.requestResponses(Arrays.asList(requestResponses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestResponses(Consumer<PutRecordBatchResponseEntry.Builder> ... requestResponses) {
            this.requestResponses(Stream.of(requestResponses).map(c -> (PutRecordBatchResponseEntry)((PutRecordBatchResponseEntry.Builder)PutRecordBatchResponseEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutRecordBatchResponse build() {
            return new PutRecordBatchResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FirehoseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRecordBatchResponse> {
        public Builder failedPutCount(Integer var1);

        public Builder encrypted(Boolean var1);

        public Builder requestResponses(Collection<PutRecordBatchResponseEntry> var1);

        public Builder requestResponses(PutRecordBatchResponseEntry ... var1);

        public Builder requestResponses(Consumer<PutRecordBatchResponseEntry.Builder> ... var1);
    }
}

