/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.DatabaseColumnIncludeOrExcludeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatabaseColumnList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatabaseColumnList> {
    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Include").getter(DatabaseColumnList.getter(DatabaseColumnList::include)).setter(DatabaseColumnList.setter(Builder::include)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Include").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Exclude").getter(DatabaseColumnList.getter(DatabaseColumnList::exclude)).setter(DatabaseColumnList.setter(Builder::exclude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclude").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_FIELD, EXCLUDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Include", INCLUDE_FIELD);
            this.put("Exclude", EXCLUDE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> include;
    private final List<String> exclude;

    private DatabaseColumnList(BuilderImpl builder) {
        this.include = builder.include;
        this.exclude = builder.exclude;
    }

    public final boolean hasInclude() {
        return this.include != null && !(this.include instanceof SdkAutoConstructList);
    }

    public final List<String> include() {
        return this.include;
    }

    public final boolean hasExclude() {
        return this.exclude != null && !(this.exclude instanceof SdkAutoConstructList);
    }

    public final List<String> exclude() {
        return this.exclude;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclude() ? this.include() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclude() ? this.exclude() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseColumnList)) {
            return false;
        }
        DatabaseColumnList other = (DatabaseColumnList)obj;
        return this.hasInclude() == other.hasInclude() && Objects.equals(this.include(), other.include()) && this.hasExclude() == other.hasExclude() && Objects.equals(this.exclude(), other.exclude());
    }

    public final String toString() {
        return ToString.builder((String)"DatabaseColumnList").add("Include", this.hasInclude() ? this.include() : null).add("Exclude", this.hasExclude() ? this.exclude() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Include": {
                return Optional.ofNullable(clazz.cast(this.include()));
            }
            case "Exclude": {
                return Optional.ofNullable(clazz.cast(this.exclude()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseColumnList, T> g) {
        return obj -> g.apply((DatabaseColumnList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> include = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclude = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseColumnList model) {
            this.include(model.include);
            this.exclude(model.exclude);
        }

        public final Collection<String> getInclude() {
            if (this.include instanceof SdkAutoConstructList) {
                return null;
            }
            return this.include;
        }

        public final void setInclude(Collection<String> include) {
            this.include = DatabaseColumnIncludeOrExcludeListCopier.copy(include);
        }

        @Override
        public final Builder include(Collection<String> include) {
            this.include = DatabaseColumnIncludeOrExcludeListCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(String ... include) {
            this.include(Arrays.asList(include));
            return this;
        }

        public final Collection<String> getExclude() {
            if (this.exclude instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclude;
        }

        public final void setExclude(Collection<String> exclude) {
            this.exclude = DatabaseColumnIncludeOrExcludeListCopier.copy(exclude);
        }

        @Override
        public final Builder exclude(Collection<String> exclude) {
            this.exclude = DatabaseColumnIncludeOrExcludeListCopier.copy(exclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclude(String ... exclude) {
            this.exclude(Arrays.asList(exclude));
            return this;
        }

        public DatabaseColumnList build() {
            return new DatabaseColumnList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatabaseColumnList> {
        public Builder include(Collection<String> var1);

        public Builder include(String ... var1);

        public Builder exclude(Collection<String> var1);

        public Builder exclude(String ... var1);
    }
}

