/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.BufferingHints;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.CompressionFormat;
import software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration;
import software.amazon.awssdk.services.firehose.model.DynamicPartitioningConfiguration;
import software.amazon.awssdk.services.firehose.model.EncryptionConfiguration;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3BackupMode;
import software.amazon.awssdk.services.firehose.model.S3DestinationUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExtendedS3DestinationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExtendedS3DestinationUpdate> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(ExtendedS3DestinationUpdate.getter(ExtendedS3DestinationUpdate::roleARN)).setter(ExtendedS3DestinationUpdate.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketARN").getter(ExtendedS3DestinationUpdate.getter(ExtendedS3DestinationUpdate::bucketARN)).setter(ExtendedS3DestinationUpdate.setter(Builder::bucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARN").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(ExtendedS3DestinationUpdate.getter(ExtendedS3DestinationUpdate::prefix)).setter(ExtendedS3DestinationUpdate.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()}).build();
    private static final SdkField<String> ERROR_OUTPUT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorOutputPrefix").getter(ExtendedS3DestinationUpdate.getter(ExtendedS3DestinationUpdate::errorOutputPrefix)).setter(ExtendedS3DestinationUpdate.setter(Builder::errorOutputPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorOutputPrefix").build()}).build();
    private static final SdkField<BufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(ExtendedS3DestinationUpdate.getter(ExtendedS3DestinationUpdate::bufferingHints)).setter(ExtendedS3DestinationUpdate.setter(Builder::bufferingHints)).constructor(BufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<String> COMPRESSION_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompressionFormat").getter(ExtendedS3DestinationUpdate.getter(ExtendedS3DestinationUpdate::compressionFormatAsString)).setter(ExtendedS3DestinationUpdate.setter(Builder::compressionFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionFormat").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(ExtendedS3DestinationUpdate.getter(ExtendedS3DestinationUpdate::encryptionConfiguration)).setter(ExtendedS3DestinationUpdate.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(ExtendedS3DestinationUpdate.getter(ExtendedS3DestinationUpdate::cloudWatchLoggingOptions)).setter(ExtendedS3DestinationUpdate.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(ExtendedS3DestinationUpdate.getter(ExtendedS3DestinationUpdate::processingConfiguration)).setter(ExtendedS3DestinationUpdate.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BackupMode").getter(ExtendedS3DestinationUpdate.getter(ExtendedS3DestinationUpdate::s3BackupModeAsString)).setter(ExtendedS3DestinationUpdate.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationUpdate> S3_BACKUP_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3BackupUpdate").getter(ExtendedS3DestinationUpdate.getter(ExtendedS3DestinationUpdate::s3BackupUpdate)).setter(ExtendedS3DestinationUpdate.setter(Builder::s3BackupUpdate)).constructor(S3DestinationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupUpdate").build()}).build();
    private static final SdkField<DataFormatConversionConfiguration> DATA_FORMAT_CONVERSION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataFormatConversionConfiguration").getter(ExtendedS3DestinationUpdate.getter(ExtendedS3DestinationUpdate::dataFormatConversionConfiguration)).setter(ExtendedS3DestinationUpdate.setter(Builder::dataFormatConversionConfiguration)).constructor(DataFormatConversionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormatConversionConfiguration").build()}).build();
    private static final SdkField<DynamicPartitioningConfiguration> DYNAMIC_PARTITIONING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DynamicPartitioningConfiguration").getter(ExtendedS3DestinationUpdate.getter(ExtendedS3DestinationUpdate::dynamicPartitioningConfiguration)).setter(ExtendedS3DestinationUpdate.setter(Builder::dynamicPartitioningConfiguration)).constructor(DynamicPartitioningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicPartitioningConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, BUCKET_ARN_FIELD, PREFIX_FIELD, ERROR_OUTPUT_PREFIX_FIELD, BUFFERING_HINTS_FIELD, COMPRESSION_FORMAT_FIELD, ENCRYPTION_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, PROCESSING_CONFIGURATION_FIELD, S3_BACKUP_MODE_FIELD, S3_BACKUP_UPDATE_FIELD, DATA_FORMAT_CONVERSION_CONFIGURATION_FIELD, DYNAMIC_PARTITIONING_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleARN;
    private final String bucketARN;
    private final String prefix;
    private final String errorOutputPrefix;
    private final BufferingHints bufferingHints;
    private final String compressionFormat;
    private final EncryptionConfiguration encryptionConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final ProcessingConfiguration processingConfiguration;
    private final String s3BackupMode;
    private final S3DestinationUpdate s3BackupUpdate;
    private final DataFormatConversionConfiguration dataFormatConversionConfiguration;
    private final DynamicPartitioningConfiguration dynamicPartitioningConfiguration;

    private ExtendedS3DestinationUpdate(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.bucketARN = builder.bucketARN;
        this.prefix = builder.prefix;
        this.errorOutputPrefix = builder.errorOutputPrefix;
        this.bufferingHints = builder.bufferingHints;
        this.compressionFormat = builder.compressionFormat;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupUpdate = builder.s3BackupUpdate;
        this.dataFormatConversionConfiguration = builder.dataFormatConversionConfiguration;
        this.dynamicPartitioningConfiguration = builder.dynamicPartitioningConfiguration;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final String bucketARN() {
        return this.bucketARN;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String errorOutputPrefix() {
        return this.errorOutputPrefix;
    }

    public final BufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public final CompressionFormat compressionFormat() {
        return CompressionFormat.fromValue(this.compressionFormat);
    }

    public final String compressionFormatAsString() {
        return this.compressionFormat;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final S3BackupMode s3BackupMode() {
        return S3BackupMode.fromValue(this.s3BackupMode);
    }

    public final String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public final S3DestinationUpdate s3BackupUpdate() {
        return this.s3BackupUpdate;
    }

    public final DataFormatConversionConfiguration dataFormatConversionConfiguration() {
        return this.dataFormatConversionConfiguration;
    }

    public final DynamicPartitioningConfiguration dynamicPartitioningConfiguration() {
        return this.dynamicPartitioningConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorOutputPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatConversionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicPartitioningConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedS3DestinationUpdate)) {
            return false;
        }
        ExtendedS3DestinationUpdate other = (ExtendedS3DestinationUpdate)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.bucketARN(), other.bucketARN()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.errorOutputPrefix(), other.errorOutputPrefix()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.compressionFormatAsString(), other.compressionFormatAsString()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3BackupUpdate(), other.s3BackupUpdate()) && Objects.equals(this.dataFormatConversionConfiguration(), other.dataFormatConversionConfiguration()) && Objects.equals(this.dynamicPartitioningConfiguration(), other.dynamicPartitioningConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ExtendedS3DestinationUpdate").add("RoleARN", (Object)this.roleARN()).add("BucketARN", (Object)this.bucketARN()).add("Prefix", (Object)this.prefix()).add("ErrorOutputPrefix", (Object)this.errorOutputPrefix()).add("BufferingHints", (Object)this.bufferingHints()).add("CompressionFormat", (Object)this.compressionFormatAsString()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3BackupUpdate", (Object)this.s3BackupUpdate()).add("DataFormatConversionConfiguration", (Object)this.dataFormatConversionConfiguration()).add("DynamicPartitioningConfiguration", (Object)this.dynamicPartitioningConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "BucketARN": {
                return Optional.ofNullable(clazz.cast(this.bucketARN()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "ErrorOutputPrefix": {
                return Optional.ofNullable(clazz.cast(this.errorOutputPrefix()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "CompressionFormat": {
                return Optional.ofNullable(clazz.cast(this.compressionFormatAsString()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3BackupUpdate": {
                return Optional.ofNullable(clazz.cast(this.s3BackupUpdate()));
            }
            case "DataFormatConversionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataFormatConversionConfiguration()));
            }
            case "DynamicPartitioningConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dynamicPartitioningConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExtendedS3DestinationUpdate, T> g) {
        return obj -> g.apply((ExtendedS3DestinationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String bucketARN;
        private String prefix;
        private String errorOutputPrefix;
        private BufferingHints bufferingHints;
        private String compressionFormat;
        private EncryptionConfiguration encryptionConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private ProcessingConfiguration processingConfiguration;
        private String s3BackupMode;
        private S3DestinationUpdate s3BackupUpdate;
        private DataFormatConversionConfiguration dataFormatConversionConfiguration;
        private DynamicPartitioningConfiguration dynamicPartitioningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendedS3DestinationUpdate model) {
            this.roleARN(model.roleARN);
            this.bucketARN(model.bucketARN);
            this.prefix(model.prefix);
            this.errorOutputPrefix(model.errorOutputPrefix);
            this.bufferingHints(model.bufferingHints);
            this.compressionFormat(model.compressionFormat);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.processingConfiguration(model.processingConfiguration);
            this.s3BackupMode(model.s3BackupMode);
            this.s3BackupUpdate(model.s3BackupUpdate);
            this.dataFormatConversionConfiguration(model.dataFormatConversionConfiguration);
            this.dynamicPartitioningConfiguration(model.dynamicPartitioningConfiguration);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        @Transient
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getBucketARN() {
            return this.bucketARN;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        @Override
        @Transient
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        @Transient
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getErrorOutputPrefix() {
            return this.errorOutputPrefix;
        }

        public final void setErrorOutputPrefix(String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
        }

        @Override
        @Transient
        public final Builder errorOutputPrefix(String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
            return this;
        }

        public final BufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(BufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        @Transient
        public final Builder bufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final String getCompressionFormat() {
            return this.compressionFormat;
        }

        public final void setCompressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
        }

        @Override
        @Transient
        public final Builder compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder compressionFormat(CompressionFormat compressionFormat) {
            this.compressionFormat(compressionFormat == null ? null : compressionFormat.toString());
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        @Transient
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        @Transient
        public final Builder s3BackupMode(S3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationUpdate.Builder getS3BackupUpdate() {
            return this.s3BackupUpdate != null ? this.s3BackupUpdate.toBuilder() : null;
        }

        public final void setS3BackupUpdate(S3DestinationUpdate.BuilderImpl s3BackupUpdate) {
            this.s3BackupUpdate = s3BackupUpdate != null ? s3BackupUpdate.build() : null;
        }

        @Override
        @Transient
        public final Builder s3BackupUpdate(S3DestinationUpdate s3BackupUpdate) {
            this.s3BackupUpdate = s3BackupUpdate;
            return this;
        }

        public final DataFormatConversionConfiguration.Builder getDataFormatConversionConfiguration() {
            return this.dataFormatConversionConfiguration != null ? this.dataFormatConversionConfiguration.toBuilder() : null;
        }

        public final void setDataFormatConversionConfiguration(DataFormatConversionConfiguration.BuilderImpl dataFormatConversionConfiguration) {
            this.dataFormatConversionConfiguration = dataFormatConversionConfiguration != null ? dataFormatConversionConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder dataFormatConversionConfiguration(DataFormatConversionConfiguration dataFormatConversionConfiguration) {
            this.dataFormatConversionConfiguration = dataFormatConversionConfiguration;
            return this;
        }

        public final DynamicPartitioningConfiguration.Builder getDynamicPartitioningConfiguration() {
            return this.dynamicPartitioningConfiguration != null ? this.dynamicPartitioningConfiguration.toBuilder() : null;
        }

        public final void setDynamicPartitioningConfiguration(DynamicPartitioningConfiguration.BuilderImpl dynamicPartitioningConfiguration) {
            this.dynamicPartitioningConfiguration = dynamicPartitioningConfiguration != null ? dynamicPartitioningConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder dynamicPartitioningConfiguration(DynamicPartitioningConfiguration dynamicPartitioningConfiguration) {
            this.dynamicPartitioningConfiguration = dynamicPartitioningConfiguration;
            return this;
        }

        public ExtendedS3DestinationUpdate build() {
            return new ExtendedS3DestinationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExtendedS3DestinationUpdate> {
        public Builder roleARN(String var1);

        public Builder bucketARN(String var1);

        public Builder prefix(String var1);

        public Builder errorOutputPrefix(String var1);

        public Builder bufferingHints(BufferingHints var1);

        default public Builder bufferingHints(Consumer<BufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((BufferingHints)((BufferingHints.Builder)BufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder compressionFormat(String var1);

        public Builder compressionFormat(CompressionFormat var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(S3BackupMode var1);

        public Builder s3BackupUpdate(S3DestinationUpdate var1);

        default public Builder s3BackupUpdate(Consumer<S3DestinationUpdate.Builder> s3BackupUpdate) {
            return this.s3BackupUpdate((S3DestinationUpdate)((S3DestinationUpdate.Builder)S3DestinationUpdate.builder().applyMutation(s3BackupUpdate)).build());
        }

        public Builder dataFormatConversionConfiguration(DataFormatConversionConfiguration var1);

        default public Builder dataFormatConversionConfiguration(Consumer<DataFormatConversionConfiguration.Builder> dataFormatConversionConfiguration) {
            return this.dataFormatConversionConfiguration((DataFormatConversionConfiguration)((DataFormatConversionConfiguration.Builder)DataFormatConversionConfiguration.builder().applyMutation(dataFormatConversionConfiguration)).build());
        }

        public Builder dynamicPartitioningConfiguration(DynamicPartitioningConfiguration var1);

        default public Builder dynamicPartitioningConfiguration(Consumer<DynamicPartitioningConfiguration.Builder> dynamicPartitioningConfiguration) {
            return this.dynamicPartitioningConfiguration((DynamicPartitioningConfiguration)((DynamicPartitioningConfiguration.Builder)DynamicPartitioningConfiguration.builder().applyMutation(dynamicPartitioningConfiguration)).build());
        }
    }
}

