/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKxVolumeRequest extends FinspaceRequest implements
        ToCopyableBuilder<UpdateKxVolumeRequest.Builder, UpdateKxVolumeRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(UpdateKxVolumeRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()).build();

    private static final SdkField<String> VOLUME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeName").getter(getter(UpdateKxVolumeRequest::volumeName)).setter(setter(Builder::volumeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("volumeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateKxVolumeRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateKxVolumeRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<KxNAS1Configuration> NAS1_CONFIGURATION_FIELD = SdkField
            .<KxNAS1Configuration> builder(MarshallingType.SDK_POJO).memberName("nas1Configuration")
            .getter(getter(UpdateKxVolumeRequest::nas1Configuration)).setter(setter(Builder::nas1Configuration))
            .constructor(KxNAS1Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nas1Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            VOLUME_NAME_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, NAS1_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String environmentId;

    private final String volumeName;

    private final String description;

    private final String clientToken;

    private final KxNAS1Configuration nas1Configuration;

    private UpdateKxVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.volumeName = builder.volumeName;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.nas1Configuration = builder.nas1Configuration;
    }

    /**
     * <p>
     * A unique identifier for the kdb environment where you created the storage volume.
     * </p>
     * 
     * @return A unique identifier for the kdb environment where you created the storage volume.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * A unique identifier for the volume.
     * </p>
     * 
     * @return A unique identifier for the volume.
     */
    public final String volumeName() {
        return volumeName;
    }

    /**
     * <p>
     * A description of the volume.
     * </p>
     * 
     * @return A description of the volume.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A token that ensures idempotency. This token expires in 10 minutes.
     * </p>
     * 
     * @return A token that ensures idempotency. This token expires in 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies the configuration for the Network attached storage (NAS_1) file system volume.
     * </p>
     * 
     * @return Specifies the configuration for the Network attached storage (NAS_1) file system volume.
     */
    public final KxNAS1Configuration nas1Configuration() {
        return nas1Configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(nas1Configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKxVolumeRequest)) {
            return false;
        }
        UpdateKxVolumeRequest other = (UpdateKxVolumeRequest) obj;
        return Objects.equals(environmentId(), other.environmentId()) && Objects.equals(volumeName(), other.volumeName())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(nas1Configuration(), other.nas1Configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKxVolumeRequest").add("EnvironmentId", environmentId()).add("VolumeName", volumeName())
                .add("Description", description()).add("ClientToken", clientToken())
                .add("Nas1Configuration", nas1Configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "volumeName":
            return Optional.ofNullable(clazz.cast(volumeName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "nas1Configuration":
            return Optional.ofNullable(clazz.cast(nas1Configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("volumeName", VOLUME_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("nas1Configuration", NAS1_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateKxVolumeRequest, T> g) {
        return obj -> g.apply((UpdateKxVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateKxVolumeRequest> {
        /**
         * <p>
         * A unique identifier for the kdb environment where you created the storage volume.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier for the kdb environment where you created the storage volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * A unique identifier for the volume.
         * </p>
         * 
         * @param volumeName
         *        A unique identifier for the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeName(String volumeName);

        /**
         * <p>
         * A description of the volume.
         * </p>
         * 
         * @param description
         *        A description of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A token that ensures idempotency. This token expires in 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures idempotency. This token expires in 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the configuration for the Network attached storage (NAS_1) file system volume.
         * </p>
         * 
         * @param nas1Configuration
         *        Specifies the configuration for the Network attached storage (NAS_1) file system volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nas1Configuration(KxNAS1Configuration nas1Configuration);

        /**
         * <p>
         * Specifies the configuration for the Network attached storage (NAS_1) file system volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link KxNAS1Configuration.Builder} avoiding the
         * need to create one manually via {@link KxNAS1Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KxNAS1Configuration.Builder#build()} is called immediately and
         * its result is passed to {@link #nas1Configuration(KxNAS1Configuration)}.
         * 
         * @param nas1Configuration
         *        a consumer that will call methods on {@link KxNAS1Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nas1Configuration(KxNAS1Configuration)
         */
        default Builder nas1Configuration(Consumer<KxNAS1Configuration.Builder> nas1Configuration) {
            return nas1Configuration(KxNAS1Configuration.builder().applyMutation(nas1Configuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceRequest.BuilderImpl implements Builder {
        private String environmentId;

        private String volumeName;

        private String description;

        private String clientToken;

        private KxNAS1Configuration nas1Configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKxVolumeRequest model) {
            super(model);
            environmentId(model.environmentId);
            volumeName(model.volumeName);
            description(model.description);
            clientToken(model.clientToken);
            nas1Configuration(model.nas1Configuration);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getVolumeName() {
            return volumeName;
        }

        public final void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @Override
        public final Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final KxNAS1Configuration.Builder getNas1Configuration() {
            return nas1Configuration != null ? nas1Configuration.toBuilder() : null;
        }

        public final void setNas1Configuration(KxNAS1Configuration.BuilderImpl nas1Configuration) {
            this.nas1Configuration = nas1Configuration != null ? nas1Configuration.build() : null;
        }

        @Override
        public final Builder nas1Configuration(KxNAS1Configuration nas1Configuration) {
            this.nas1Configuration = nas1Configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKxVolumeRequest build() {
            return new UpdateKxVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
