/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration to store the Tickerplant logs. It consists of a list of volumes that will be mounted to your cluster.
 * For the cluster type <code>Tickerplant</code>, the location of the TP volume on the cluster will be available by
 * using the global variable <code>.aws.tp_log_path</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TickerplantLogConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TickerplantLogConfiguration.Builder, TickerplantLogConfiguration> {
    private static final SdkField<List<String>> TICKERPLANT_LOG_VOLUMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("tickerplantLogVolumes")
            .getter(getter(TickerplantLogConfiguration::tickerplantLogVolumes))
            .setter(setter(Builder::tickerplantLogVolumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tickerplantLogVolumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TICKERPLANT_LOG_VOLUMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> tickerplantLogVolumes;

    private TickerplantLogConfiguration(BuilderImpl builder) {
        this.tickerplantLogVolumes = builder.tickerplantLogVolumes;
    }

    /**
     * For responses, this returns true if the service returned a value for the TickerplantLogVolumes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTickerplantLogVolumes() {
        return tickerplantLogVolumes != null && !(tickerplantLogVolumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the volumes for tickerplant logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTickerplantLogVolumes} method.
     * </p>
     * 
     * @return The name of the volumes for tickerplant logs.
     */
    public final List<String> tickerplantLogVolumes() {
        return tickerplantLogVolumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTickerplantLogVolumes() ? tickerplantLogVolumes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TickerplantLogConfiguration)) {
            return false;
        }
        TickerplantLogConfiguration other = (TickerplantLogConfiguration) obj;
        return hasTickerplantLogVolumes() == other.hasTickerplantLogVolumes()
                && Objects.equals(tickerplantLogVolumes(), other.tickerplantLogVolumes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TickerplantLogConfiguration")
                .add("TickerplantLogVolumes", hasTickerplantLogVolumes() ? tickerplantLogVolumes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tickerplantLogVolumes":
            return Optional.ofNullable(clazz.cast(tickerplantLogVolumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tickerplantLogVolumes", TICKERPLANT_LOG_VOLUMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TickerplantLogConfiguration, T> g) {
        return obj -> g.apply((TickerplantLogConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TickerplantLogConfiguration> {
        /**
         * <p>
         * The name of the volumes for tickerplant logs.
         * </p>
         * 
         * @param tickerplantLogVolumes
         *        The name of the volumes for tickerplant logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tickerplantLogVolumes(Collection<String> tickerplantLogVolumes);

        /**
         * <p>
         * The name of the volumes for tickerplant logs.
         * </p>
         * 
         * @param tickerplantLogVolumes
         *        The name of the volumes for tickerplant logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tickerplantLogVolumes(String... tickerplantLogVolumes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> tickerplantLogVolumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TickerplantLogConfiguration model) {
            tickerplantLogVolumes(model.tickerplantLogVolumes);
        }

        public final Collection<String> getTickerplantLogVolumes() {
            if (tickerplantLogVolumes instanceof SdkAutoConstructList) {
                return null;
            }
            return tickerplantLogVolumes;
        }

        public final void setTickerplantLogVolumes(Collection<String> tickerplantLogVolumes) {
            this.tickerplantLogVolumes = TickerplantLogVolumesCopier.copy(tickerplantLogVolumes);
        }

        @Override
        public final Builder tickerplantLogVolumes(Collection<String> tickerplantLogVolumes) {
            this.tickerplantLogVolumes = TickerplantLogVolumesCopier.copy(tickerplantLogVolumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tickerplantLogVolumes(String... tickerplantLogVolumes) {
            tickerplantLogVolumes(Arrays.asList(tickerplantLogVolumes));
            return this;
        }

        @Override
        public TickerplantLogConfiguration build() {
            return new TickerplantLogConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
