/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The size and type of temporary storage that is used to hold data during the savedown process. All the data written to
 * this storage space is lost when the cluster node is restarted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KxSavedownStorageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KxSavedownStorageConfiguration.Builder, KxSavedownStorageConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(KxSavedownStorageConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("size")
            .getter(getter(KxSavedownStorageConfiguration::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()).build();

    private static final SdkField<String> VOLUME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeName").getter(getter(KxSavedownStorageConfiguration::volumeName))
            .setter(setter(Builder::volumeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SIZE_FIELD,
            VOLUME_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer size;

    private final String volumeName;

    private KxSavedownStorageConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.size = builder.size;
        this.volumeName = builder.volumeName;
    }

    /**
     * <p>
     * The type of writeable storage space for temporarily storing your savedown data. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SDS01 – This type represents 3000 IOPS and io2 ebs volume type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link KxSavedownStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of writeable storage space for temporarily storing your savedown data. The valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         SDS01 – This type represents 3000 IOPS and io2 ebs volume type.
     *         </p>
     *         </li>
     * @see KxSavedownStorageType
     */
    public final KxSavedownStorageType type() {
        return KxSavedownStorageType.fromValue(type);
    }

    /**
     * <p>
     * The type of writeable storage space for temporarily storing your savedown data. The valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SDS01 – This type represents 3000 IOPS and io2 ebs volume type.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link KxSavedownStorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of writeable storage space for temporarily storing your savedown data. The valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         SDS01 – This type represents 3000 IOPS and io2 ebs volume type.
     *         </p>
     *         </li>
     * @see KxSavedownStorageType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The size of temporary storage in gibibytes.
     * </p>
     * 
     * @return The size of temporary storage in gibibytes.
     */
    public final Integer size() {
        return size;
    }

    /**
     * <p>
     * The name of the kdb volume that you want to use as writeable save-down storage for clusters.
     * </p>
     * 
     * @return The name of the kdb volume that you want to use as writeable save-down storage for clusters.
     */
    public final String volumeName() {
        return volumeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(volumeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxSavedownStorageConfiguration)) {
            return false;
        }
        KxSavedownStorageConfiguration other = (KxSavedownStorageConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(size(), other.size())
                && Objects.equals(volumeName(), other.volumeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KxSavedownStorageConfiguration").add("Type", typeAsString()).add("Size", size())
                .add("VolumeName", volumeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "size":
            return Optional.ofNullable(clazz.cast(size()));
        case "volumeName":
            return Optional.ofNullable(clazz.cast(volumeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("size", SIZE_FIELD);
        map.put("volumeName", VOLUME_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KxSavedownStorageConfiguration, T> g) {
        return obj -> g.apply((KxSavedownStorageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KxSavedownStorageConfiguration> {
        /**
         * <p>
         * The type of writeable storage space for temporarily storing your savedown data. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SDS01 – This type represents 3000 IOPS and io2 ebs volume type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of writeable storage space for temporarily storing your savedown data. The valid values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        SDS01 – This type represents 3000 IOPS and io2 ebs volume type.
         *        </p>
         *        </li>
         * @see KxSavedownStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxSavedownStorageType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of writeable storage space for temporarily storing your savedown data. The valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SDS01 – This type represents 3000 IOPS and io2 ebs volume type.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of writeable storage space for temporarily storing your savedown data. The valid values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        SDS01 – This type represents 3000 IOPS and io2 ebs volume type.
         *        </p>
         *        </li>
         * @see KxSavedownStorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxSavedownStorageType
         */
        Builder type(KxSavedownStorageType type);

        /**
         * <p>
         * The size of temporary storage in gibibytes.
         * </p>
         * 
         * @param size
         *        The size of temporary storage in gibibytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The name of the kdb volume that you want to use as writeable save-down storage for clusters.
         * </p>
         * 
         * @param volumeName
         *        The name of the kdb volume that you want to use as writeable save-down storage for clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeName(String volumeName);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer size;

        private String volumeName;

        private BuilderImpl() {
        }

        private BuilderImpl(KxSavedownStorageConfiguration model) {
            type(model.type);
            size(model.size);
            volumeName(model.volumeName);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(KxSavedownStorageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final String getVolumeName() {
            return volumeName;
        }

        public final void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @Override
        public final Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        @Override
        public KxSavedownStorageConfiguration build() {
            return new KxSavedownStorageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
