/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information when authentication mode is FEDERATED.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FederationParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<FederationParameters.Builder, FederationParameters> {
    private static final SdkField<String> SAML_METADATA_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("samlMetadataDocument").getter(getter(FederationParameters::samlMetadataDocument))
            .setter(setter(Builder::samlMetadataDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlMetadataDocument").build())
            .build();

    private static final SdkField<String> SAML_METADATA_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("samlMetadataURL").getter(getter(FederationParameters::samlMetadataURL))
            .setter(setter(Builder::samlMetadataURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlMetadataURL").build()).build();

    private static final SdkField<String> APPLICATION_CALL_BACK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationCallBackURL").getter(getter(FederationParameters::applicationCallBackURL))
            .setter(setter(Builder::applicationCallBackURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationCallBackURL").build())
            .build();

    private static final SdkField<String> FEDERATION_URN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("federationURN").getter(getter(FederationParameters::federationURN))
            .setter(setter(Builder::federationURN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationURN").build()).build();

    private static final SdkField<String> FEDERATION_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("federationProviderName").getter(getter(FederationParameters::federationProviderName))
            .setter(setter(Builder::federationProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federationProviderName").build())
            .build();

    private static final SdkField<Map<String, String>> ATTRIBUTE_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributeMap")
            .getter(getter(FederationParameters::attributeMap))
            .setter(setter(Builder::attributeMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_METADATA_DOCUMENT_FIELD,
            SAML_METADATA_URL_FIELD, APPLICATION_CALL_BACK_URL_FIELD, FEDERATION_URN_FIELD, FEDERATION_PROVIDER_NAME_FIELD,
            ATTRIBUTE_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String samlMetadataDocument;

    private final String samlMetadataURL;

    private final String applicationCallBackURL;

    private final String federationURN;

    private final String federationProviderName;

    private final Map<String, String> attributeMap;

    private FederationParameters(BuilderImpl builder) {
        this.samlMetadataDocument = builder.samlMetadataDocument;
        this.samlMetadataURL = builder.samlMetadataURL;
        this.applicationCallBackURL = builder.applicationCallBackURL;
        this.federationURN = builder.federationURN;
        this.federationProviderName = builder.federationProviderName;
        this.attributeMap = builder.attributeMap;
    }

    /**
     * <p>
     * SAML 2.0 Metadata document from identity provider (IdP).
     * </p>
     * 
     * @return SAML 2.0 Metadata document from identity provider (IdP).
     */
    public final String samlMetadataDocument() {
        return samlMetadataDocument;
    }

    /**
     * <p>
     * Provide the metadata URL from your SAML 2.0 compliant identity provider (IdP).
     * </p>
     * 
     * @return Provide the metadata URL from your SAML 2.0 compliant identity provider (IdP).
     */
    public final String samlMetadataURL() {
        return samlMetadataURL;
    }

    /**
     * <p>
     * The redirect or sign-in URL that should be entered into the SAML 2.0 compliant identity provider configuration
     * (IdP).
     * </p>
     * 
     * @return The redirect or sign-in URL that should be entered into the SAML 2.0 compliant identity provider
     *         configuration (IdP).
     */
    public final String applicationCallBackURL() {
        return applicationCallBackURL;
    }

    /**
     * <p>
     * The Uniform Resource Name (URN). Also referred as Service Provider URN or Audience URI or Service Provider Entity
     * ID.
     * </p>
     * 
     * @return The Uniform Resource Name (URN). Also referred as Service Provider URN or Audience URI or Service
     *         Provider Entity ID.
     */
    public final String federationURN() {
        return federationURN;
    }

    /**
     * <p>
     * Name of the identity provider (IdP).
     * </p>
     * 
     * @return Name of the identity provider (IdP).
     */
    public final String federationProviderName() {
        return federationProviderName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeMap() {
        return attributeMap != null && !(attributeMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * SAML attribute name and value. The name must always be <code>Email</code> and the value should be set to the
     * attribute definition in which user email is set. For example, name would be <code>Email</code> and value
     * <code>http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress</code>. Please check your SAML 2.0
     * compliant identity provider (IdP) documentation for details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeMap} method.
     * </p>
     * 
     * @return SAML attribute name and value. The name must always be <code>Email</code> and the value should be set to
     *         the attribute definition in which user email is set. For example, name would be <code>Email</code> and
     *         value <code>http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress</code>. Please check your
     *         SAML 2.0 compliant identity provider (IdP) documentation for details.
     */
    public final Map<String, String> attributeMap() {
        return attributeMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(samlMetadataDocument());
        hashCode = 31 * hashCode + Objects.hashCode(samlMetadataURL());
        hashCode = 31 * hashCode + Objects.hashCode(applicationCallBackURL());
        hashCode = 31 * hashCode + Objects.hashCode(federationURN());
        hashCode = 31 * hashCode + Objects.hashCode(federationProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeMap() ? attributeMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FederationParameters)) {
            return false;
        }
        FederationParameters other = (FederationParameters) obj;
        return Objects.equals(samlMetadataDocument(), other.samlMetadataDocument())
                && Objects.equals(samlMetadataURL(), other.samlMetadataURL())
                && Objects.equals(applicationCallBackURL(), other.applicationCallBackURL())
                && Objects.equals(federationURN(), other.federationURN())
                && Objects.equals(federationProviderName(), other.federationProviderName())
                && hasAttributeMap() == other.hasAttributeMap() && Objects.equals(attributeMap(), other.attributeMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FederationParameters").add("SamlMetadataDocument", samlMetadataDocument())
                .add("SamlMetadataURL", samlMetadataURL()).add("ApplicationCallBackURL", applicationCallBackURL())
                .add("FederationURN", federationURN()).add("FederationProviderName", federationProviderName())
                .add("AttributeMap", hasAttributeMap() ? attributeMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "samlMetadataDocument":
            return Optional.ofNullable(clazz.cast(samlMetadataDocument()));
        case "samlMetadataURL":
            return Optional.ofNullable(clazz.cast(samlMetadataURL()));
        case "applicationCallBackURL":
            return Optional.ofNullable(clazz.cast(applicationCallBackURL()));
        case "federationURN":
            return Optional.ofNullable(clazz.cast(federationURN()));
        case "federationProviderName":
            return Optional.ofNullable(clazz.cast(federationProviderName()));
        case "attributeMap":
            return Optional.ofNullable(clazz.cast(attributeMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("samlMetadataDocument", SAML_METADATA_DOCUMENT_FIELD);
        map.put("samlMetadataURL", SAML_METADATA_URL_FIELD);
        map.put("applicationCallBackURL", APPLICATION_CALL_BACK_URL_FIELD);
        map.put("federationURN", FEDERATION_URN_FIELD);
        map.put("federationProviderName", FEDERATION_PROVIDER_NAME_FIELD);
        map.put("attributeMap", ATTRIBUTE_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FederationParameters, T> g) {
        return obj -> g.apply((FederationParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FederationParameters> {
        /**
         * <p>
         * SAML 2.0 Metadata document from identity provider (IdP).
         * </p>
         * 
         * @param samlMetadataDocument
         *        SAML 2.0 Metadata document from identity provider (IdP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlMetadataDocument(String samlMetadataDocument);

        /**
         * <p>
         * Provide the metadata URL from your SAML 2.0 compliant identity provider (IdP).
         * </p>
         * 
         * @param samlMetadataURL
         *        Provide the metadata URL from your SAML 2.0 compliant identity provider (IdP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlMetadataURL(String samlMetadataURL);

        /**
         * <p>
         * The redirect or sign-in URL that should be entered into the SAML 2.0 compliant identity provider
         * configuration (IdP).
         * </p>
         * 
         * @param applicationCallBackURL
         *        The redirect or sign-in URL that should be entered into the SAML 2.0 compliant identity provider
         *        configuration (IdP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCallBackURL(String applicationCallBackURL);

        /**
         * <p>
         * The Uniform Resource Name (URN). Also referred as Service Provider URN or Audience URI or Service Provider
         * Entity ID.
         * </p>
         * 
         * @param federationURN
         *        The Uniform Resource Name (URN). Also referred as Service Provider URN or Audience URI or Service
         *        Provider Entity ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder federationURN(String federationURN);

        /**
         * <p>
         * Name of the identity provider (IdP).
         * </p>
         * 
         * @param federationProviderName
         *        Name of the identity provider (IdP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder federationProviderName(String federationProviderName);

        /**
         * <p>
         * SAML attribute name and value. The name must always be <code>Email</code> and the value should be set to the
         * attribute definition in which user email is set. For example, name would be <code>Email</code> and value
         * <code>http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress</code>. Please check your SAML 2.0
         * compliant identity provider (IdP) documentation for details.
         * </p>
         * 
         * @param attributeMap
         *        SAML attribute name and value. The name must always be <code>Email</code> and the value should be set
         *        to the attribute definition in which user email is set. For example, name would be <code>Email</code>
         *        and value <code>http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress</code>. Please
         *        check your SAML 2.0 compliant identity provider (IdP) documentation for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeMap(Map<String, String> attributeMap);
    }

    static final class BuilderImpl implements Builder {
        private String samlMetadataDocument;

        private String samlMetadataURL;

        private String applicationCallBackURL;

        private String federationURN;

        private String federationProviderName;

        private Map<String, String> attributeMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FederationParameters model) {
            samlMetadataDocument(model.samlMetadataDocument);
            samlMetadataURL(model.samlMetadataURL);
            applicationCallBackURL(model.applicationCallBackURL);
            federationURN(model.federationURN);
            federationProviderName(model.federationProviderName);
            attributeMap(model.attributeMap);
        }

        public final String getSamlMetadataDocument() {
            return samlMetadataDocument;
        }

        public final void setSamlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
        }

        @Override
        public final Builder samlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
            return this;
        }

        public final String getSamlMetadataURL() {
            return samlMetadataURL;
        }

        public final void setSamlMetadataURL(String samlMetadataURL) {
            this.samlMetadataURL = samlMetadataURL;
        }

        @Override
        public final Builder samlMetadataURL(String samlMetadataURL) {
            this.samlMetadataURL = samlMetadataURL;
            return this;
        }

        public final String getApplicationCallBackURL() {
            return applicationCallBackURL;
        }

        public final void setApplicationCallBackURL(String applicationCallBackURL) {
            this.applicationCallBackURL = applicationCallBackURL;
        }

        @Override
        public final Builder applicationCallBackURL(String applicationCallBackURL) {
            this.applicationCallBackURL = applicationCallBackURL;
            return this;
        }

        public final String getFederationURN() {
            return federationURN;
        }

        public final void setFederationURN(String federationURN) {
            this.federationURN = federationURN;
        }

        @Override
        public final Builder federationURN(String federationURN) {
            this.federationURN = federationURN;
            return this;
        }

        public final String getFederationProviderName() {
            return federationProviderName;
        }

        public final void setFederationProviderName(String federationProviderName) {
            this.federationProviderName = federationProviderName;
        }

        @Override
        public final Builder federationProviderName(String federationProviderName) {
            this.federationProviderName = federationProviderName;
            return this;
        }

        public final Map<String, String> getAttributeMap() {
            if (attributeMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributeMap;
        }

        public final void setAttributeMap(Map<String, String> attributeMap) {
            this.attributeMap = AttributeMapCopier.copy(attributeMap);
        }

        @Override
        public final Builder attributeMap(Map<String, String> attributeMap) {
            this.attributeMap = AttributeMapCopier.copy(attributeMap);
            return this;
        }

        @Override
        public FederationParameters build() {
            return new FederationParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
