/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure of the customer code available within the running cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeConfiguration.Builder, CodeConfiguration> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3Bucket").getter(getter(CodeConfiguration::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final SdkField<String> S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Key")
            .getter(getter(CodeConfiguration::s3Key)).setter(setter(Builder::s3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Key").build()).build();

    private static final SdkField<String> S3_OBJECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3ObjectVersion").getter(getter(CodeConfiguration::s3ObjectVersion))
            .setter(setter(Builder::s3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ObjectVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, S3_KEY_FIELD,
            S3_OBJECT_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3Bucket;

    private final String s3Key;

    private final String s3ObjectVersion;

    private CodeConfiguration(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3ObjectVersion = builder.s3ObjectVersion;
    }

    /**
     * <p>
     * A unique name for the S3 bucket.
     * </p>
     * 
     * @return A unique name for the S3 bucket.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The full S3 path (excluding bucket) to the .zip file. This file contains the code that is loaded onto the cluster
     * when it's started.
     * </p>
     * 
     * @return The full S3 path (excluding bucket) to the .zip file. This file contains the code that is loaded onto the
     *         cluster when it's started.
     */
    public final String s3Key() {
        return s3Key;
    }

    /**
     * <p>
     * The version of an S3 object.
     * </p>
     * 
     * @return The version of an S3 object.
     */
    public final String s3ObjectVersion() {
        return s3ObjectVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(s3ObjectVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeConfiguration)) {
            return false;
        }
        CodeConfiguration other = (CodeConfiguration) obj;
        return Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3Key(), other.s3Key())
                && Objects.equals(s3ObjectVersion(), other.s3ObjectVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeConfiguration").add("S3Bucket", s3Bucket()).add("S3Key", s3Key())
                .add("S3ObjectVersion", s3ObjectVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "s3Key":
            return Optional.ofNullable(clazz.cast(s3Key()));
        case "s3ObjectVersion":
            return Optional.ofNullable(clazz.cast(s3ObjectVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Bucket", S3_BUCKET_FIELD);
        map.put("s3Key", S3_KEY_FIELD);
        map.put("s3ObjectVersion", S3_OBJECT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeConfiguration, T> g) {
        return obj -> g.apply((CodeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeConfiguration> {
        /**
         * <p>
         * A unique name for the S3 bucket.
         * </p>
         * 
         * @param s3Bucket
         *        A unique name for the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The full S3 path (excluding bucket) to the .zip file. This file contains the code that is loaded onto the
         * cluster when it's started.
         * </p>
         * 
         * @param s3Key
         *        The full S3 path (excluding bucket) to the .zip file. This file contains the code that is loaded onto
         *        the cluster when it's started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);

        /**
         * <p>
         * The version of an S3 object.
         * </p>
         * 
         * @param s3ObjectVersion
         *        The version of an S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ObjectVersion(String s3ObjectVersion);
    }

    static final class BuilderImpl implements Builder {
        private String s3Bucket;

        private String s3Key;

        private String s3ObjectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeConfiguration model) {
            s3Bucket(model.s3Bucket);
            s3Key(model.s3Key);
            s3ObjectVersion(model.s3ObjectVersion);
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Key() {
            return s3Key;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final String getS3ObjectVersion() {
            return s3ObjectVersion;
        }

        public final void setS3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
        }

        @Override
        public final Builder s3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
            return this;
        }

        @Override
        public CodeConfiguration build() {
            return new CodeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
