/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.model.TestEventPatternRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TestEventPatternRequestModelMarshaller {
    private static final MarshallingInfo<String> EVENTPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventPattern").isBinary(false).build();
    private static final MarshallingInfo<String> EVENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Event").isBinary(false).build();
    private static final TestEventPatternRequestModelMarshaller INSTANCE = new TestEventPatternRequestModelMarshaller();

    private TestEventPatternRequestModelMarshaller() {
    }

    public static TestEventPatternRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TestEventPatternRequest testEventPatternRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)testEventPatternRequest), (String)"testEventPatternRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)testEventPatternRequest.eventPattern(), EVENTPATTERN_BINDING);
            protocolMarshaller.marshall((Object)testEventPatternRequest.event(), EVENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

