/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.model.Target;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TargetMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> INPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Input").isBinary(false).build();
    private static final MarshallingInfo<String> INPUTPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputPath").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INPUTTRANSFORMER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputTransformer").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> KINESISPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisParameters").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RUNCOMMANDPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RunCommandParameters").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ECSPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EcsParameters").isBinary(false).build();
    private static final TargetMarshaller INSTANCE = new TargetMarshaller();

    private TargetMarshaller() {
    }

    public static TargetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Target target, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)target, (String)"target");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)target.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)target.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)target.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)target.input(), INPUT_BINDING);
            protocolMarshaller.marshall((Object)target.inputPath(), INPUTPATH_BINDING);
            protocolMarshaller.marshall((Object)target.inputTransformer(), INPUTTRANSFORMER_BINDING);
            protocolMarshaller.marshall((Object)target.kinesisParameters(), KINESISPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)target.runCommandParameters(), RUNCOMMANDPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)target.ecsParameters(), ECSPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

