/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatchevents.model.Rule;

public class RuleUnmarshaller
implements Unmarshaller<Rule, JsonUnmarshallerContext> {
    private static final RuleUnmarshaller INSTANCE = new RuleUnmarshaller();

    public Rule unmarshall(JsonUnmarshallerContext context) throws Exception {
        Rule.Builder ruleBuilder = Rule.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    ruleBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Arn", targetDepth)) {
                    context.nextToken();
                    ruleBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EventPattern", targetDepth)) {
                    context.nextToken();
                    ruleBuilder.eventPattern((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    ruleBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    ruleBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ScheduleExpression", targetDepth)) {
                    context.nextToken();
                    ruleBuilder.scheduleExpression((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RoleArn", targetDepth)) {
                    context.nextToken();
                    ruleBuilder.roleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Rule)ruleBuilder.build();
    }

    public static RuleUnmarshaller getInstance() {
        return INSTANCE;
    }
}

