/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.model.KinesisParameters;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KinesisParametersMarshaller {
    private static final MarshallingInfo<String> PARTITIONKEYPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionKeyPath").isBinary(false).build();
    private static final KinesisParametersMarshaller INSTANCE = new KinesisParametersMarshaller();

    private KinesisParametersMarshaller() {
    }

    public static KinesisParametersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KinesisParameters kinesisParameters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)kinesisParameters, (String)"kinesisParameters");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)kinesisParameters.partitionKeyPath(), PARTITIONKEYPATH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

