/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.model.InputTransformer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputTransformerMarshaller {
    private static final MarshallingInfo<Map> INPUTPATHSMAP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputPathsMap").isBinary(false).build();
    private static final MarshallingInfo<String> INPUTTEMPLATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputTemplate").isBinary(false).build();
    private static final InputTransformerMarshaller INSTANCE = new InputTransformerMarshaller();

    private InputTransformerMarshaller() {
    }

    public static InputTransformerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputTransformer inputTransformer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputTransformer, (String)"inputTransformer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(inputTransformer.inputPathsMap(), INPUTPATHSMAP_BINDING);
            protocolMarshaller.marshall((Object)inputTransformer.inputTemplate(), INPUTTEMPLATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

