/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.model.EcsParameters;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EcsParametersMarshaller {
    private static final MarshallingInfo<String> TASKDEFINITIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskDefinitionArn").isBinary(false).build();
    private static final MarshallingInfo<Integer> TASKCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskCount").isBinary(false).build();
    private static final EcsParametersMarshaller INSTANCE = new EcsParametersMarshaller();

    private EcsParametersMarshaller() {
    }

    public static EcsParametersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EcsParameters ecsParameters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ecsParameters, (String)"ecsParameters");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ecsParameters.taskDefinitionArn(), TASKDEFINITIONARN_BINDING);
            protocolMarshaller.marshall((Object)ecsParameters.taskCount(), TASKCOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

