/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.RunCommandTarget;
import software.amazon.awssdk.services.cloudwatchevents.model.RunCommandTargetsCopier;
import software.amazon.awssdk.services.cloudwatchevents.transform.RunCommandParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunCommandParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, RunCommandParameters> {
    private final List<RunCommandTarget> runCommandTargets;

    private RunCommandParameters(BuilderImpl builder) {
        this.runCommandTargets = builder.runCommandTargets;
    }

    public List<RunCommandTarget> runCommandTargets() {
        return this.runCommandTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.runCommandTargets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunCommandParameters)) {
            return false;
        }
        RunCommandParameters other = (RunCommandParameters)obj;
        return Objects.equals(this.runCommandTargets(), other.runCommandTargets());
    }

    public String toString() {
        return ToString.builder((String)"RunCommandParameters").add("RunCommandTargets", this.runCommandTargets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RunCommandTargets": {
                return Optional.ofNullable(clazz.cast(this.runCommandTargets()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RunCommandParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RunCommandTarget> runCommandTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RunCommandParameters model) {
            this.runCommandTargets(model.runCommandTargets);
        }

        public final Collection<RunCommandTarget.Builder> getRunCommandTargets() {
            return this.runCommandTargets != null ? (Collection)this.runCommandTargets.stream().map(RunCommandTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder runCommandTargets(Collection<RunCommandTarget> runCommandTargets) {
            this.runCommandTargets = RunCommandTargetsCopier.copy(runCommandTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runCommandTargets(RunCommandTarget ... runCommandTargets) {
            this.runCommandTargets(Arrays.asList(runCommandTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runCommandTargets(Consumer<RunCommandTarget.Builder> ... runCommandTargets) {
            this.runCommandTargets(Stream.of(runCommandTargets).map(c -> (RunCommandTarget)((RunCommandTarget.Builder)RunCommandTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRunCommandTargets(Collection<RunCommandTarget.BuilderImpl> runCommandTargets) {
            this.runCommandTargets = RunCommandTargetsCopier.copyFromBuilder(runCommandTargets);
        }

        public RunCommandParameters build() {
            return new RunCommandParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RunCommandParameters> {
        public Builder runCommandTargets(Collection<RunCommandTarget> var1);

        public Builder runCommandTargets(RunCommandTarget ... var1);

        public Builder runCommandTargets(Consumer<RunCommandTarget.Builder> ... var1);
    }
}

