/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsRequest;
import software.amazon.awssdk.services.cloudwatchevents.model.TargetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveTargetsRequest
extends CloudWatchEventsRequest
implements ToCopyableBuilder<Builder, RemoveTargetsRequest> {
    private final String rule;
    private final List<String> ids;

    private RemoveTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.rule = builder.rule;
        this.ids = builder.ids;
    }

    public String rule() {
        return this.rule;
    }

    public List<String> ids() {
        return this.ids;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.ids());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTargetsRequest)) {
            return false;
        }
        RemoveTargetsRequest other = (RemoveTargetsRequest)((Object)obj);
        return Objects.equals(this.rule(), other.rule()) && Objects.equals(this.ids(), other.ids());
    }

    public String toString() {
        return ToString.builder((String)"RemoveTargetsRequest").add("Rule", (Object)this.rule()).add("Ids", this.ids()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "Ids": {
                return Optional.ofNullable(clazz.cast(this.ids()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchEventsRequest.BuilderImpl
    implements Builder {
        private String rule;
        private List<String> ids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTargetsRequest model) {
            super(model);
            this.rule(model.rule);
            this.ids(model.ids);
        }

        public final String getRule() {
            return this.rule;
        }

        @Override
        public final Builder rule(String rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(String rule) {
            this.rule = rule;
        }

        public final Collection<String> getIds() {
            return this.ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = TargetIdListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String ... ids) {
            this.ids(Arrays.asList(ids));
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = TargetIdListCopier.copy(ids);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveTargetsRequest build() {
            return new RemoveTargetsRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchEventsRequest.Builder,
    CopyableBuilder<Builder, RemoveTargetsRequest> {
        public Builder rule(String var1);

        public Builder ids(Collection<String> var1);

        public Builder ids(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

