/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutEventsResultEntry;
import software.amazon.awssdk.services.cloudwatchevents.model.PutEventsResultEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventsResponse
extends CloudWatchEventsResponse
implements ToCopyableBuilder<Builder, PutEventsResponse> {
    private final Integer failedEntryCount;
    private final List<PutEventsResultEntry> entries;

    private PutEventsResponse(BuilderImpl builder) {
        super(builder);
        this.failedEntryCount = builder.failedEntryCount;
        this.entries = builder.entries;
    }

    public Integer failedEntryCount() {
        return this.failedEntryCount;
    }

    public List<PutEventsResultEntry> entries() {
        return this.entries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failedEntryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.entries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsResponse)) {
            return false;
        }
        PutEventsResponse other = (PutEventsResponse)((Object)obj);
        return Objects.equals(this.failedEntryCount(), other.failedEntryCount()) && Objects.equals(this.entries(), other.entries());
    }

    public String toString() {
        return ToString.builder((String)"PutEventsResponse").add("FailedEntryCount", (Object)this.failedEntryCount()).add("Entries", this.entries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedEntryCount": {
                return Optional.ofNullable(clazz.cast(this.failedEntryCount()));
            }
            case "Entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchEventsResponse.BuilderImpl
    implements Builder {
        private Integer failedEntryCount;
        private List<PutEventsResultEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsResponse model) {
            super(model);
            this.failedEntryCount(model.failedEntryCount);
            this.entries(model.entries);
        }

        public final Integer getFailedEntryCount() {
            return this.failedEntryCount;
        }

        @Override
        public final Builder failedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
            return this;
        }

        public final void setFailedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
        }

        public final Collection<PutEventsResultEntry.Builder> getEntries() {
            return this.entries != null ? (Collection)this.entries.stream().map(PutEventsResultEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<PutEventsResultEntry> entries) {
            this.entries = PutEventsResultEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(PutEventsResultEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<PutEventsResultEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (PutEventsResultEntry)((PutEventsResultEntry.Builder)PutEventsResultEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<PutEventsResultEntry.BuilderImpl> entries) {
            this.entries = PutEventsResultEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public PutEventsResponse build() {
            return new PutEventsResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchEventsResponse.Builder,
    CopyableBuilder<Builder, PutEventsResponse> {
        public Builder failedEntryCount(Integer var1);

        public Builder entries(Collection<PutEventsResultEntry> var1);

        public Builder entries(PutEventsResultEntry ... var1);

        public Builder entries(Consumer<PutEventsResultEntry.Builder> ... var1);
    }
}

