/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.RuleNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRuleNamesByTargetResponse
extends CloudWatchEventsResponse
implements ToCopyableBuilder<Builder, ListRuleNamesByTargetResponse> {
    private final List<String> ruleNames;
    private final String nextToken;

    private ListRuleNamesByTargetResponse(BuilderImpl builder) {
        super(builder);
        this.ruleNames = builder.ruleNames;
        this.nextToken = builder.nextToken;
    }

    public List<String> ruleNames() {
        return this.ruleNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRuleNamesByTargetResponse)) {
            return false;
        }
        ListRuleNamesByTargetResponse other = (ListRuleNamesByTargetResponse)((Object)obj);
        return Objects.equals(this.ruleNames(), other.ruleNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRuleNamesByTargetResponse").add("RuleNames", this.ruleNames()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleNames": {
                return Optional.ofNullable(clazz.cast(this.ruleNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchEventsResponse.BuilderImpl
    implements Builder {
        private List<String> ruleNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRuleNamesByTargetResponse model) {
            super(model);
            this.ruleNames(model.ruleNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getRuleNames() {
            return this.ruleNames;
        }

        @Override
        public final Builder ruleNames(Collection<String> ruleNames) {
            this.ruleNames = RuleNameListCopier.copy(ruleNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleNames(String ... ruleNames) {
            this.ruleNames(Arrays.asList(ruleNames));
            return this;
        }

        public final void setRuleNames(Collection<String> ruleNames) {
            this.ruleNames = RuleNameListCopier.copy(ruleNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRuleNamesByTargetResponse build() {
            return new ListRuleNamesByTargetResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchEventsResponse.Builder,
    CopyableBuilder<Builder, ListRuleNamesByTargetResponse> {
        public Builder ruleNames(Collection<String> var1);

        public Builder ruleNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

