/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.transform.KinesisParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, KinesisParameters> {
    private final String partitionKeyPath;

    private KinesisParameters(BuilderImpl builder) {
        this.partitionKeyPath = builder.partitionKeyPath;
    }

    public String partitionKeyPath() {
        return this.partitionKeyPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionKeyPath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisParameters)) {
            return false;
        }
        KinesisParameters other = (KinesisParameters)obj;
        return Objects.equals(this.partitionKeyPath(), other.partitionKeyPath());
    }

    public String toString() {
        return ToString.builder((String)"KinesisParameters").add("PartitionKeyPath", (Object)this.partitionKeyPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartitionKeyPath": {
                return Optional.ofNullable(clazz.cast(this.partitionKeyPath()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String partitionKeyPath;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisParameters model) {
            this.partitionKeyPath(model.partitionKeyPath);
        }

        public final String getPartitionKeyPath() {
            return this.partitionKeyPath;
        }

        @Override
        public final Builder partitionKeyPath(String partitionKeyPath) {
            this.partitionKeyPath = partitionKeyPath;
            return this;
        }

        public final void setPartitionKeyPath(String partitionKeyPath) {
            this.partitionKeyPath = partitionKeyPath;
        }

        public KinesisParameters build() {
            return new KinesisParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KinesisParameters> {
        public Builder partitionKeyPath(String var1);
    }
}

