/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchevents.model.TransformerPathsCopier;
import software.amazon.awssdk.services.cloudwatchevents.transform.InputTransformerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputTransformer
implements StructuredPojo,
ToCopyableBuilder<Builder, InputTransformer> {
    private final Map<String, String> inputPathsMap;
    private final String inputTemplate;

    private InputTransformer(BuilderImpl builder) {
        this.inputPathsMap = builder.inputPathsMap;
        this.inputTemplate = builder.inputTemplate;
    }

    public Map<String, String> inputPathsMap() {
        return this.inputPathsMap;
    }

    public String inputTemplate() {
        return this.inputTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputPathsMap());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTemplate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputTransformer)) {
            return false;
        }
        InputTransformer other = (InputTransformer)obj;
        return Objects.equals(this.inputPathsMap(), other.inputPathsMap()) && Objects.equals(this.inputTemplate(), other.inputTemplate());
    }

    public String toString() {
        return ToString.builder((String)"InputTransformer").add("InputPathsMap", this.inputPathsMap()).add("InputTemplate", (Object)this.inputTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputPathsMap": {
                return Optional.ofNullable(clazz.cast(this.inputPathsMap()));
            }
            case "InputTemplate": {
                return Optional.ofNullable(clazz.cast(this.inputTemplate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputTransformerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> inputPathsMap = DefaultSdkAutoConstructMap.getInstance();
        private String inputTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputTransformer model) {
            this.inputPathsMap(model.inputPathsMap);
            this.inputTemplate(model.inputTemplate);
        }

        public final Map<String, String> getInputPathsMap() {
            return this.inputPathsMap;
        }

        @Override
        public final Builder inputPathsMap(Map<String, String> inputPathsMap) {
            this.inputPathsMap = TransformerPathsCopier.copy(inputPathsMap);
            return this;
        }

        public final void setInputPathsMap(Map<String, String> inputPathsMap) {
            this.inputPathsMap = TransformerPathsCopier.copy(inputPathsMap);
        }

        public final String getInputTemplate() {
            return this.inputTemplate;
        }

        @Override
        public final Builder inputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
            return this;
        }

        public final void setInputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
        }

        public InputTransformer build() {
            return new InputTransformer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputTransformer> {
        public Builder inputPathsMap(Map<String, String> var1);

        public Builder inputTemplate(String var1);
    }
}

