/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.transform.EcsParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, EcsParameters> {
    private final String taskDefinitionArn;
    private final Integer taskCount;

    private EcsParameters(BuilderImpl builder) {
        this.taskDefinitionArn = builder.taskDefinitionArn;
        this.taskCount = builder.taskCount;
    }

    public String taskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public Integer taskCount() {
        return this.taskCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsParameters)) {
            return false;
        }
        EcsParameters other = (EcsParameters)obj;
        return Objects.equals(this.taskDefinitionArn(), other.taskDefinitionArn()) && Objects.equals(this.taskCount(), other.taskCount());
    }

    public String toString() {
        return ToString.builder((String)"EcsParameters").add("TaskDefinitionArn", (Object)this.taskDefinitionArn()).add("TaskCount", (Object)this.taskCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitionArn()));
            }
            case "TaskCount": {
                return Optional.ofNullable(clazz.cast(this.taskCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EcsParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskDefinitionArn;
        private Integer taskCount;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsParameters model) {
            this.taskDefinitionArn(model.taskDefinitionArn);
            this.taskCount(model.taskCount);
        }

        public final String getTaskDefinitionArn() {
            return this.taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        public final Integer getTaskCount() {
            return this.taskCount;
        }

        @Override
        public final Builder taskCount(Integer taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        public final void setTaskCount(Integer taskCount) {
            this.taskCount = taskCount;
        }

        public EcsParameters build() {
            return new EcsParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EcsParameters> {
        public Builder taskDefinitionArn(String var1);

        public Builder taskCount(Integer var1);
    }
}

