/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.model.PutEventsRequestEntry;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link PutEventsRequestEntry} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class PutEventsRequestEntryMarshaller {
    private static final MarshallingInfo<Instant> TIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Time").isBinary(false).build();

    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").isBinary(false).build();

    private static final MarshallingInfo<List> RESOURCES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").isBinary(false).build();

    private static final MarshallingInfo<String> DETAILTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetailType").isBinary(false).build();

    private static final MarshallingInfo<String> DETAIL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Detail").isBinary(false).build();

    private static final PutEventsRequestEntryMarshaller INSTANCE = new PutEventsRequestEntryMarshaller();

    private PutEventsRequestEntryMarshaller() {
    }

    public static PutEventsRequestEntryMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(PutEventsRequestEntry putEventsRequestEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(putEventsRequestEntry, "putEventsRequestEntry");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(putEventsRequestEntry.time(), TIME_BINDING);
            protocolMarshaller.marshall(putEventsRequestEntry.source(), SOURCE_BINDING);
            protocolMarshaller.marshall(putEventsRequestEntry.resources(), RESOURCES_BINDING);
            protocolMarshaller.marshall(putEventsRequestEntry.detailType(), DETAILTYPE_BINDING);
            protocolMarshaller.marshall(putEventsRequestEntry.detail(), DETAIL_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
