/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestEventPatternRequest extends CloudWatchEventsRequest implements
        ToCopyableBuilder<TestEventPatternRequest.Builder, TestEventPatternRequest> {
    private final String eventPattern;

    private final String event;

    private TestEventPatternRequest(BuilderImpl builder) {
        super(builder);
        this.eventPattern = builder.eventPattern;
        this.event = builder.event;
    }

    /**
     * <p>
     * The event pattern. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html">Events and
     * Event Patterns</a> in the <i>Amazon CloudWatch Events User Guide</i>.
     * </p>
     * 
     * @return The event pattern. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html"
     *         >Events and Event Patterns</a> in the <i>Amazon CloudWatch Events User Guide</i>.
     */
    public String eventPattern() {
        return eventPattern;
    }

    /**
     * <p>
     * The event, in JSON format, to test against the event pattern.
     * </p>
     * 
     * @return The event, in JSON format, to test against the event pattern.
     */
    public String event() {
        return event;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(event());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestEventPatternRequest)) {
            return false;
        }
        TestEventPatternRequest other = (TestEventPatternRequest) obj;
        return Objects.equals(eventPattern(), other.eventPattern()) && Objects.equals(event(), other.event());
    }

    @Override
    public String toString() {
        return ToString.builder("TestEventPatternRequest").add("EventPattern", eventPattern()).add("Event", event()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventPattern":
            return Optional.ofNullable(clazz.cast(eventPattern()));
        case "Event":
            return Optional.ofNullable(clazz.cast(event()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchEventsRequest.Builder, CopyableBuilder<Builder, TestEventPatternRequest> {
        /**
         * <p>
         * The event pattern. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html">Events
         * and Event Patterns</a> in the <i>Amazon CloudWatch Events User Guide</i>.
         * </p>
         * 
         * @param eventPattern
         *        The event pattern. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html"
         *        >Events and Event Patterns</a> in the <i>Amazon CloudWatch Events User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventPattern(String eventPattern);

        /**
         * <p>
         * The event, in JSON format, to test against the event pattern.
         * </p>
         * 
         * @param event
         *        The event, in JSON format, to test against the event pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder event(String event);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchEventsRequest.BuilderImpl implements Builder {
        private String eventPattern;

        private String event;

        private BuilderImpl() {
        }

        private BuilderImpl(TestEventPatternRequest model) {
            super(model);
            eventPattern(model.eventPattern);
            event(model.event);
        }

        public final String getEventPattern() {
            return eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        public final String getEvent() {
            return event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestEventPatternRequest build() {
            return new TestEventPatternRequest(this);
        }
    }
}
