/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPermissionRequest extends CloudWatchEventsRequest implements
        ToCopyableBuilder<PutPermissionRequest.Builder, PutPermissionRequest> {
    private final String action;

    private final String principal;

    private final String statementId;

    private PutPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.principal = builder.principal;
        this.statementId = builder.statementId;
    }

    /**
     * <p>
     * The action that you are enabling the other account to perform. Currently, this must be
     * <code>events:PutEvents</code>.
     * </p>
     * 
     * @return The action that you are enabling the other account to perform. Currently, this must be
     *         <code>events:PutEvents</code>.
     */
    public String action() {
        return action;
    }

    /**
     * <p>
     * The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify "*" to
     * permit any account to put events to your default event bus.
     * </p>
     * <p>
     * If you specify "*", avoid creating rules that may match undesirable events. To create more secure rules, make
     * sure that the event pattern for each rule contains an <code>account</code> field with a specific account ID from
     * which to receive events. Rules with an account field do not match any events sent from other accounts.
     * </p>
     * 
     * @return The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify "*"
     *         to permit any account to put events to your default event bus.</p>
     *         <p>
     *         If you specify "*", avoid creating rules that may match undesirable events. To create more secure rules,
     *         make sure that the event pattern for each rule contains an <code>account</code> field with a specific
     *         account ID from which to receive events. Rules with an account field do not match any events sent from
     *         other accounts.
     */
    public String principal() {
        return principal;
    }

    /**
     * <p>
     * An identifier string for the external account that you are granting permissions to. If you later want to revoke
     * the permission for this external account, specify this <code>StatementId</code> when you run
     * <a>RemovePermission</a>.
     * </p>
     * 
     * @return An identifier string for the external account that you are granting permissions to. If you later want to
     *         revoke the permission for this external account, specify this <code>StatementId</code> when you run
     *         <a>RemovePermission</a>.
     */
    public String statementId() {
        return statementId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPermissionRequest)) {
            return false;
        }
        PutPermissionRequest other = (PutPermissionRequest) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(principal(), other.principal())
                && Objects.equals(statementId(), other.statementId());
    }

    @Override
    public String toString() {
        return ToString.builder("PutPermissionRequest").add("Action", action()).add("Principal", principal())
                .add("StatementId", statementId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "StatementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchEventsRequest.Builder, CopyableBuilder<Builder, PutPermissionRequest> {
        /**
         * <p>
         * The action that you are enabling the other account to perform. Currently, this must be
         * <code>events:PutEvents</code>.
         * </p>
         * 
         * @param action
         *        The action that you are enabling the other account to perform. Currently, this must be
         *        <code>events:PutEvents</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify "*" to
         * permit any account to put events to your default event bus.
         * </p>
         * <p>
         * If you specify "*", avoid creating rules that may match undesirable events. To create more secure rules, make
         * sure that the event pattern for each rule contains an <code>account</code> field with a specific account ID
         * from which to receive events. Rules with an account field do not match any events sent from other accounts.
         * </p>
         * 
         * @param principal
         *        The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify
         *        "*" to permit any account to put events to your default event bus.</p>
         *        <p>
         *        If you specify "*", avoid creating rules that may match undesirable events. To create more secure
         *        rules, make sure that the event pattern for each rule contains an <code>account</code> field with a
         *        specific account ID from which to receive events. Rules with an account field do not match any events
         *        sent from other accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * An identifier string for the external account that you are granting permissions to. If you later want to
         * revoke the permission for this external account, specify this <code>StatementId</code> when you run
         * <a>RemovePermission</a>.
         * </p>
         * 
         * @param statementId
         *        An identifier string for the external account that you are granting permissions to. If you later want
         *        to revoke the permission for this external account, specify this <code>StatementId</code> when you run
         *        <a>RemovePermission</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchEventsRequest.BuilderImpl implements Builder {
        private String action;

        private String principal;

        private String statementId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPermissionRequest model) {
            super(model);
            action(model.action);
            principal(model.principal);
            statementId(model.statementId);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getPrincipal() {
            return principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        public final String getStatementId() {
            return statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPermissionRequest build() {
            return new PutPermissionRequest(this);
        }
    }
}
