/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchevents.transform.InputTransformerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters needed for you to provide custom input to a target based on one or more pieces of data
 * extracted from the event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputTransformer implements StructuredPojo, ToCopyableBuilder<InputTransformer.Builder, InputTransformer> {
    private final Map<String, String> inputPathsMap;

    private final String inputTemplate;

    private InputTransformer(BuilderImpl builder) {
        this.inputPathsMap = builder.inputPathsMap;
        this.inputTemplate = builder.inputTemplate;
    }

    /**
     * <p>
     * Map of JSON paths to be extracted from the event. These are key-value pairs, where each value is a JSON path. You
     * must use JSON dot notation, not bracket notation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Map of JSON paths to be extracted from the event. These are key-value pairs, where each value is a JSON
     *         path. You must use JSON dot notation, not bracket notation.
     */
    public Map<String, String> inputPathsMap() {
        return inputPathsMap;
    }

    /**
     * <p>
     * Input template where you can use the values of the keys from <code>InputPathsMap</code> to customize the data
     * sent to the target.
     * </p>
     * 
     * @return Input template where you can use the values of the keys from <code>InputPathsMap</code> to customize the
     *         data sent to the target.
     */
    public String inputTemplate() {
        return inputTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputPathsMap());
        hashCode = 31 * hashCode + Objects.hashCode(inputTemplate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputTransformer)) {
            return false;
        }
        InputTransformer other = (InputTransformer) obj;
        return Objects.equals(inputPathsMap(), other.inputPathsMap()) && Objects.equals(inputTemplate(), other.inputTemplate());
    }

    @Override
    public String toString() {
        return ToString.builder("InputTransformer").add("InputPathsMap", inputPathsMap()).add("InputTemplate", inputTemplate())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputPathsMap":
            return Optional.ofNullable(clazz.cast(inputPathsMap()));
        case "InputTemplate":
            return Optional.ofNullable(clazz.cast(inputTemplate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputTransformerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputTransformer> {
        /**
         * <p>
         * Map of JSON paths to be extracted from the event. These are key-value pairs, where each value is a JSON path.
         * You must use JSON dot notation, not bracket notation.
         * </p>
         * 
         * @param inputPathsMap
         *        Map of JSON paths to be extracted from the event. These are key-value pairs, where each value is a
         *        JSON path. You must use JSON dot notation, not bracket notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputPathsMap(Map<String, String> inputPathsMap);

        /**
         * <p>
         * Input template where you can use the values of the keys from <code>InputPathsMap</code> to customize the data
         * sent to the target.
         * </p>
         * 
         * @param inputTemplate
         *        Input template where you can use the values of the keys from <code>InputPathsMap</code> to customize
         *        the data sent to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputTemplate(String inputTemplate);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> inputPathsMap = DefaultSdkAutoConstructMap.getInstance();

        private String inputTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputTransformer model) {
            inputPathsMap(model.inputPathsMap);
            inputTemplate(model.inputTemplate);
        }

        public final Map<String, String> getInputPathsMap() {
            return inputPathsMap;
        }

        @Override
        public final Builder inputPathsMap(Map<String, String> inputPathsMap) {
            this.inputPathsMap = TransformerPathsCopier.copy(inputPathsMap);
            return this;
        }

        public final void setInputPathsMap(Map<String, String> inputPathsMap) {
            this.inputPathsMap = TransformerPathsCopier.copy(inputPathsMap);
        }

        public final String getInputTemplate() {
            return inputTemplate;
        }

        @Override
        public final Builder inputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
            return this;
        }

        public final void setInputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
        }

        @Override
        public InputTransformer build() {
            return new InputTransformer(this);
        }
    }
}
