/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventBusResponse extends CloudWatchEventsResponse implements
        ToCopyableBuilder<DescribeEventBusResponse.Builder, DescribeEventBusResponse> {
    private final String name;

    private final String arn;

    private final String policy;

    private DescribeEventBusResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.policy = builder.policy;
    }

    /**
     * <p>
     * The name of the event bus. Currently, this is always <code>default</code>.
     * </p>
     * 
     * @return The name of the event bus. Currently, this is always <code>default</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the account permitted to write events to the current account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the account permitted to write events to the current account.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The policy that enables the external account to send events to your account.
     * </p>
     * 
     * @return The policy that enables the external account to send events to your account.
     */
    public String policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventBusResponse)) {
            return false;
        }
        DescribeEventBusResponse other = (DescribeEventBusResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(policy(), other.policy());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeEventBusResponse").add("Name", name()).add("Arn", arn()).add("Policy", policy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudWatchEventsResponse.Builder, CopyableBuilder<Builder, DescribeEventBusResponse> {
        /**
         * <p>
         * The name of the event bus. Currently, this is always <code>default</code>.
         * </p>
         * 
         * @param name
         *        The name of the event bus. Currently, this is always <code>default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the account permitted to write events to the current account.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the account permitted to write events to the current account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The policy that enables the external account to send events to your account.
         * </p>
         * 
         * @param policy
         *        The policy that enables the external account to send events to your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);
    }

    static final class BuilderImpl extends CloudWatchEventsResponse.BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventBusResponse model) {
            super(model);
            name(model.name);
            arn(model.arn);
            policy(model.policy);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public DescribeEventBusResponse build() {
            return new DescribeEventBusResponse(this);
        }
    }
}
