/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionAsyncClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsResponse;
import software.amazon.awssdk.services.entityresolution.model.MatchingWorkflowSummary;

public class ListMatchingWorkflowsPublisher
implements SdkPublisher<ListMatchingWorkflowsResponse> {
    private final EntityResolutionAsyncClient client;
    private final ListMatchingWorkflowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMatchingWorkflowsPublisher(EntityResolutionAsyncClient client, ListMatchingWorkflowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMatchingWorkflowsPublisher(EntityResolutionAsyncClient client, ListMatchingWorkflowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMatchingWorkflowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMatchingWorkflowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MatchingWorkflowSummary> workflowSummaries() {
        Function<ListMatchingWorkflowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowSummaries() != null) {
                return response.workflowSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMatchingWorkflowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMatchingWorkflowsResponseFetcher
    implements AsyncPageFetcher<ListMatchingWorkflowsResponse> {
        private ListMatchingWorkflowsResponseFetcher() {
        }

        public boolean hasNextPage(ListMatchingWorkflowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMatchingWorkflowsResponse> nextPage(ListMatchingWorkflowsResponse previousPage) {
            if (previousPage == null) {
                return ListMatchingWorkflowsPublisher.this.client.listMatchingWorkflows(ListMatchingWorkflowsPublisher.this.firstRequest);
            }
            return ListMatchingWorkflowsPublisher.this.client.listMatchingWorkflows((ListMatchingWorkflowsRequest)((Object)ListMatchingWorkflowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

