/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartIdMappingJobRequest extends EntityResolutionRequest implements
        ToCopyableBuilder<StartIdMappingJobRequest.Builder, StartIdMappingJobRequest> {
    private static final SdkField<List<IdMappingJobOutputSource>> OUTPUT_SOURCE_CONFIG_FIELD = SdkField
            .<List<IdMappingJobOutputSource>> builder(MarshallingType.LIST)
            .memberName("outputSourceConfig")
            .getter(getter(StartIdMappingJobRequest::outputSourceConfig))
            .setter(setter(Builder::outputSourceConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSourceConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdMappingJobOutputSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdMappingJobOutputSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowName").getter(getter(StartIdMappingJobRequest::workflowName))
            .setter(setter(Builder::workflowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_SOURCE_CONFIG_FIELD,
            WORKFLOW_NAME_FIELD));

    private final List<IdMappingJobOutputSource> outputSourceConfig;

    private final String workflowName;

    private StartIdMappingJobRequest(BuilderImpl builder) {
        super(builder);
        this.outputSourceConfig = builder.outputSourceConfig;
        this.workflowName = builder.workflowName;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputSourceConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputSourceConfig() {
        return outputSourceConfig != null && !(outputSourceConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>OutputSource</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputSourceConfig} method.
     * </p>
     * 
     * @return A list of <code>OutputSource</code> objects.
     */
    public final List<IdMappingJobOutputSource> outputSourceConfig() {
        return outputSourceConfig;
    }

    /**
     * <p>
     * The name of the ID mapping job to be retrieved.
     * </p>
     * 
     * @return The name of the ID mapping job to be retrieved.
     */
    public final String workflowName() {
        return workflowName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputSourceConfig() ? outputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workflowName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartIdMappingJobRequest)) {
            return false;
        }
        StartIdMappingJobRequest other = (StartIdMappingJobRequest) obj;
        return hasOutputSourceConfig() == other.hasOutputSourceConfig()
                && Objects.equals(outputSourceConfig(), other.outputSourceConfig())
                && Objects.equals(workflowName(), other.workflowName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartIdMappingJobRequest")
                .add("OutputSourceConfig", hasOutputSourceConfig() ? outputSourceConfig() : null)
                .add("WorkflowName", workflowName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outputSourceConfig":
            return Optional.ofNullable(clazz.cast(outputSourceConfig()));
        case "workflowName":
            return Optional.ofNullable(clazz.cast(workflowName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartIdMappingJobRequest, T> g) {
        return obj -> g.apply((StartIdMappingJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartIdMappingJobRequest> {
        /**
         * <p>
         * A list of <code>OutputSource</code> objects.
         * </p>
         * 
         * @param outputSourceConfig
         *        A list of <code>OutputSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceConfig(Collection<IdMappingJobOutputSource> outputSourceConfig);

        /**
         * <p>
         * A list of <code>OutputSource</code> objects.
         * </p>
         * 
         * @param outputSourceConfig
         *        A list of <code>OutputSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputSourceConfig(IdMappingJobOutputSource... outputSourceConfig);

        /**
         * <p>
         * A list of <code>OutputSource</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource.Builder#build()} is
         * called immediately and its result is passed to {@link #outputSourceConfig(List<IdMappingJobOutputSource>)}.
         * 
         * @param outputSourceConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputSourceConfig(java.util.Collection<IdMappingJobOutputSource>)
         */
        Builder outputSourceConfig(Consumer<IdMappingJobOutputSource.Builder>... outputSourceConfig);

        /**
         * <p>
         * The name of the ID mapping job to be retrieved.
         * </p>
         * 
         * @param workflowName
         *        The name of the ID mapping job to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowName(String workflowName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EntityResolutionRequest.BuilderImpl implements Builder {
        private List<IdMappingJobOutputSource> outputSourceConfig = DefaultSdkAutoConstructList.getInstance();

        private String workflowName;

        private BuilderImpl() {
        }

        private BuilderImpl(StartIdMappingJobRequest model) {
            super(model);
            outputSourceConfig(model.outputSourceConfig);
            workflowName(model.workflowName);
        }

        public final List<IdMappingJobOutputSource.Builder> getOutputSourceConfig() {
            List<IdMappingJobOutputSource.Builder> result = IdMappingJobOutputSourceConfigCopier
                    .copyToBuilder(this.outputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSourceConfig(Collection<IdMappingJobOutputSource.BuilderImpl> outputSourceConfig) {
            this.outputSourceConfig = IdMappingJobOutputSourceConfigCopier.copyFromBuilder(outputSourceConfig);
        }

        @Override
        public final Builder outputSourceConfig(Collection<IdMappingJobOutputSource> outputSourceConfig) {
            this.outputSourceConfig = IdMappingJobOutputSourceConfigCopier.copy(outputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(IdMappingJobOutputSource... outputSourceConfig) {
            outputSourceConfig(Arrays.asList(outputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(Consumer<IdMappingJobOutputSource.Builder>... outputSourceConfig) {
            outputSourceConfig(Stream.of(outputSourceConfig)
                    .map(c -> IdMappingJobOutputSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkflowName() {
            return workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartIdMappingJobRequest build() {
            return new StartIdMappingJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
