/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and
 * <code>Hashed</code>. Each of these objects selects a column to be included in the output table, and whether the
 * values of the column should be hashed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputSource implements SdkPojo, Serializable, ToCopyableBuilder<OutputSource.Builder, OutputSource> {
    private static final SdkField<String> KMS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KMSArn")
            .getter(getter(OutputSource::kmsArn)).setter(setter(Builder::kmsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSArn").build()).build();

    private static final SdkField<Boolean> APPLY_NORMALIZATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("applyNormalization").getter(getter(OutputSource::applyNormalization))
            .setter(setter(Builder::applyNormalization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyNormalization").build())
            .build();

    private static final SdkField<List<OutputAttribute>> OUTPUT_FIELD = SdkField
            .<List<OutputAttribute>> builder(MarshallingType.LIST)
            .memberName("output")
            .getter(getter(OutputSource::output))
            .setter(setter(Builder::output))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OUTPUT_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3Path").getter(getter(OutputSource::outputS3Path)).setter(setter(Builder::outputS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_ARN_FIELD,
            APPLY_NORMALIZATION_FIELD, OUTPUT_FIELD, OUTPUT_S3_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsArn;

    private final Boolean applyNormalization;

    private final List<OutputAttribute> output;

    private final String outputS3Path;

    private OutputSource(BuilderImpl builder) {
        this.kmsArn = builder.kmsArn;
        this.applyNormalization = builder.applyNormalization;
        this.output = builder.output;
        this.outputS3Path = builder.outputS3Path;
    }

    /**
     * <p>
     * Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS key.
     * </p>
     * 
     * @return Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed
     *         KMS key.
     */
    public final String kmsArn() {
        return kmsArn;
    }

    /**
     * <p>
     * Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an
     * <code>AttributeType</code> of <code>PHONE_NUMBER</code>, and the data in the input table is in a format of
     * 1234567890, Entity Resolution will normalize this field in the output to (123)-456-7890.
     * </p>
     * 
     * @return Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an
     *         <code>AttributeType</code> of <code>PHONE_NUMBER</code>, and the data in the input table is in a format
     *         of 1234567890, Entity Resolution will normalize this field in the output to (123)-456-7890.
     */
    public final Boolean applyNormalization() {
        return applyNormalization;
    }

    /**
     * For responses, this returns true if the service returned a value for the Output property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutput() {
        return output != null && !(output instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and
     * <code>Hashed</code>. Each of these objects selects a column to be included in the output table, and whether the
     * values of the column should be hashed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutput} method.
     * </p>
     * 
     * @return A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and
     *         <code>Hashed</code>. Each of these objects selects a column to be included in the output table, and
     *         whether the values of the column should be hashed.
     */
    public final List<OutputAttribute> output() {
        return output;
    }

    /**
     * <p>
     * The S3 path to which Entity Resolution will write the output table.
     * </p>
     * 
     * @return The S3 path to which Entity Resolution will write the output table.
     */
    public final String outputS3Path() {
        return outputS3Path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(applyNormalization());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutput() ? output() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSource)) {
            return false;
        }
        OutputSource other = (OutputSource) obj;
        return Objects.equals(kmsArn(), other.kmsArn()) && Objects.equals(applyNormalization(), other.applyNormalization())
                && hasOutput() == other.hasOutput() && Objects.equals(output(), other.output())
                && Objects.equals(outputS3Path(), other.outputS3Path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputSource").add("KMSArn", kmsArn()).add("ApplyNormalization", applyNormalization())
                .add("Output", hasOutput() ? output() : null).add("OutputS3Path", outputS3Path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KMSArn":
            return Optional.ofNullable(clazz.cast(kmsArn()));
        case "applyNormalization":
            return Optional.ofNullable(clazz.cast(applyNormalization()));
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        case "outputS3Path":
            return Optional.ofNullable(clazz.cast(outputS3Path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputSource, T> g) {
        return obj -> g.apply((OutputSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputSource> {
        /**
         * <p>
         * Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS
         * key.
         * </p>
         * 
         * @param kmsArn
         *        Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed
         *        KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsArn(String kmsArn);

        /**
         * <p>
         * Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an
         * <code>AttributeType</code> of <code>PHONE_NUMBER</code>, and the data in the input table is in a format of
         * 1234567890, Entity Resolution will normalize this field in the output to (123)-456-7890.
         * </p>
         * 
         * @param applyNormalization
         *        Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an
         *        <code>AttributeType</code> of <code>PHONE_NUMBER</code>, and the data in the input table is in a
         *        format of 1234567890, Entity Resolution will normalize this field in the output to (123)-456-7890.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyNormalization(Boolean applyNormalization);

        /**
         * <p>
         * A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and
         * <code>Hashed</code>. Each of these objects selects a column to be included in the output table, and whether
         * the values of the column should be hashed.
         * </p>
         * 
         * @param output
         *        A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and
         *        <code>Hashed</code>. Each of these objects selects a column to be included in the output table, and
         *        whether the values of the column should be hashed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(Collection<OutputAttribute> output);

        /**
         * <p>
         * A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and
         * <code>Hashed</code>. Each of these objects selects a column to be included in the output table, and whether
         * the values of the column should be hashed.
         * </p>
         * 
         * @param output
         *        A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and
         *        <code>Hashed</code>. Each of these objects selects a column to be included in the output table, and
         *        whether the values of the column should be hashed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(OutputAttribute... output);

        /**
         * <p>
         * A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and
         * <code>Hashed</code>. Each of these objects selects a column to be included in the output table, and whether
         * the values of the column should be hashed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.OutputAttribute.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.OutputAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.OutputAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #output(List<OutputAttribute>)}.
         * 
         * @param output
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.OutputAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(java.util.Collection<OutputAttribute>)
         */
        Builder output(Consumer<OutputAttribute.Builder>... output);

        /**
         * <p>
         * The S3 path to which Entity Resolution will write the output table.
         * </p>
         * 
         * @param outputS3Path
         *        The S3 path to which Entity Resolution will write the output table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Path(String outputS3Path);
    }

    static final class BuilderImpl implements Builder {
        private String kmsArn;

        private Boolean applyNormalization;

        private List<OutputAttribute> output = DefaultSdkAutoConstructList.getInstance();

        private String outputS3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSource model) {
            kmsArn(model.kmsArn);
            applyNormalization(model.applyNormalization);
            output(model.output);
            outputS3Path(model.outputS3Path);
        }

        public final String getKmsArn() {
            return kmsArn;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final Boolean getApplyNormalization() {
            return applyNormalization;
        }

        public final void setApplyNormalization(Boolean applyNormalization) {
            this.applyNormalization = applyNormalization;
        }

        @Override
        public final Builder applyNormalization(Boolean applyNormalization) {
            this.applyNormalization = applyNormalization;
            return this;
        }

        public final List<OutputAttribute.Builder> getOutput() {
            List<OutputAttribute.Builder> result = OutputSourceOutputListCopier.copyToBuilder(this.output);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutput(Collection<OutputAttribute.BuilderImpl> output) {
            this.output = OutputSourceOutputListCopier.copyFromBuilder(output);
        }

        @Override
        public final Builder output(Collection<OutputAttribute> output) {
            this.output = OutputSourceOutputListCopier.copy(output);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder output(OutputAttribute... output) {
            output(Arrays.asList(output));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder output(Consumer<OutputAttribute.Builder>... output) {
            output(Stream.of(output).map(c -> OutputAttribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOutputS3Path() {
            return outputS3Path;
        }

        public final void setOutputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
        }

        @Override
        public final Builder outputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
            return this;
        }

        @Override
        public OutputSource build() {
            return new OutputSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
