/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of ID namespaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdNamespaceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IdNamespaceSummary.Builder, IdNamespaceSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(IdNamespaceSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(IdNamespaceSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_NAMESPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idNamespaceArn").getter(getter(IdNamespaceSummary::idNamespaceArn))
            .setter(setter(Builder::idNamespaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idNamespaceArn").build()).build();

    private static final SdkField<String> ID_NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idNamespaceName").getter(getter(IdNamespaceSummary::idNamespaceName))
            .setter(setter(Builder::idNamespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idNamespaceName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(IdNamespaceSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(IdNamespaceSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DESCRIPTION_FIELD, ID_NAMESPACE_ARN_FIELD, ID_NAMESPACE_NAME_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String description;

    private final String idNamespaceArn;

    private final String idNamespaceName;

    private final String type;

    private final Instant updatedAt;

    private IdNamespaceSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.idNamespaceArn = builder.idNamespaceArn;
        this.idNamespaceName = builder.idNamespaceName;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The timestamp of when the ID namespace was created.
     * </p>
     * 
     * @return The timestamp of when the ID namespace was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description of the ID namespace.
     * </p>
     * 
     * @return The description of the ID namespace.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ID namespace.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ID namespace.
     */
    public final String idNamespaceArn() {
        return idNamespaceArn;
    }

    /**
     * <p>
     * The name of the ID namespace.
     * </p>
     * 
     * @return The name of the ID namespace.
     */
    public final String idNamespaceName() {
        return idNamespaceName;
    }

    /**
     * <p>
     * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.
     * </p>
     * <p>
     * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID
     * mapping workflow.
     * </p>
     * <p>
     * The <code>TARGET</code> contains a configuration of <code>targetId</code> to which all <code>sourceIds</code>
     * will resolve to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IdNamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.</p>
     *         <p>
     *         The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in
     *         an ID mapping workflow.
     *         </p>
     *         <p>
     *         The <code>TARGET</code> contains a configuration of <code>targetId</code> to which all
     *         <code>sourceIds</code> will resolve to.
     * @see IdNamespaceType
     */
    public final IdNamespaceType type() {
        return IdNamespaceType.fromValue(type);
    }

    /**
     * <p>
     * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.
     * </p>
     * <p>
     * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID
     * mapping workflow.
     * </p>
     * <p>
     * The <code>TARGET</code> contains a configuration of <code>targetId</code> to which all <code>sourceIds</code>
     * will resolve to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IdNamespaceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.</p>
     *         <p>
     *         The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in
     *         an ID mapping workflow.
     *         </p>
     *         <p>
     *         The <code>TARGET</code> contains a configuration of <code>targetId</code> to which all
     *         <code>sourceIds</code> will resolve to.
     * @see IdNamespaceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The timestamp of when the ID namespace was last updated.
     * </p>
     * 
     * @return The timestamp of when the ID namespace was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(idNamespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(idNamespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdNamespaceSummary)) {
            return false;
        }
        IdNamespaceSummary other = (IdNamespaceSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(idNamespaceArn(), other.idNamespaceArn())
                && Objects.equals(idNamespaceName(), other.idNamespaceName())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdNamespaceSummary").add("CreatedAt", createdAt()).add("Description", description())
                .add("IdNamespaceArn", idNamespaceArn()).add("IdNamespaceName", idNamespaceName()).add("Type", typeAsString())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "idNamespaceArn":
            return Optional.ofNullable(clazz.cast(idNamespaceArn()));
        case "idNamespaceName":
            return Optional.ofNullable(clazz.cast(idNamespaceName()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdNamespaceSummary, T> g) {
        return obj -> g.apply((IdNamespaceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdNamespaceSummary> {
        /**
         * <p>
         * The timestamp of when the ID namespace was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the ID namespace was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description of the ID namespace.
         * </p>
         * 
         * @param description
         *        The description of the ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ID namespace.
         * </p>
         * 
         * @param idNamespaceArn
         *        The Amazon Resource Name (ARN) of the ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idNamespaceArn(String idNamespaceArn);

        /**
         * <p>
         * The name of the ID namespace.
         * </p>
         * 
         * @param idNamespaceName
         *        The name of the ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idNamespaceName(String idNamespaceName);

        /**
         * <p>
         * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.
         * </p>
         * <p>
         * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an
         * ID mapping workflow.
         * </p>
         * <p>
         * The <code>TARGET</code> contains a configuration of <code>targetId</code> to which all <code>sourceIds</code>
         * will resolve to.
         * </p>
         * 
         * @param type
         *        The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.</p>
         *        <p>
         *        The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed
         *        in an ID mapping workflow.
         *        </p>
         *        <p>
         *        The <code>TARGET</code> contains a configuration of <code>targetId</code> to which all
         *        <code>sourceIds</code> will resolve to.
         * @see IdNamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdNamespaceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.
         * </p>
         * <p>
         * The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an
         * ID mapping workflow.
         * </p>
         * <p>
         * The <code>TARGET</code> contains a configuration of <code>targetId</code> to which all <code>sourceIds</code>
         * will resolve to.
         * </p>
         * 
         * @param type
         *        The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.</p>
         *        <p>
         *        The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed
         *        in an ID mapping workflow.
         *        </p>
         *        <p>
         *        The <code>TARGET</code> contains a configuration of <code>targetId</code> to which all
         *        <code>sourceIds</code> will resolve to.
         * @see IdNamespaceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdNamespaceType
         */
        Builder type(IdNamespaceType type);

        /**
         * <p>
         * The timestamp of when the ID namespace was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the ID namespace was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String description;

        private String idNamespaceArn;

        private String idNamespaceName;

        private String type;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(IdNamespaceSummary model) {
            createdAt(model.createdAt);
            description(model.description);
            idNamespaceArn(model.idNamespaceArn);
            idNamespaceName(model.idNamespaceName);
            type(model.type);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIdNamespaceArn() {
            return idNamespaceArn;
        }

        public final void setIdNamespaceArn(String idNamespaceArn) {
            this.idNamespaceArn = idNamespaceArn;
        }

        @Override
        public final Builder idNamespaceArn(String idNamespaceArn) {
            this.idNamespaceArn = idNamespaceArn;
            return this;
        }

        public final String getIdNamespaceName() {
            return idNamespaceName;
        }

        public final void setIdNamespaceName(String idNamespaceName) {
            this.idNamespaceName = idNamespaceName;
        }

        @Override
        public final Builder idNamespaceName(String idNamespaceName) {
            this.idNamespaceName = idNamespaceName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IdNamespaceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public IdNamespaceSummary build() {
            return new IdNamespaceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
