/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteUniqueIdResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<BatchDeleteUniqueIdResponse.Builder, BatchDeleteUniqueIdResponse> {
    private static final SdkField<List<DeletedUniqueId>> DELETED_FIELD = SdkField
            .<List<DeletedUniqueId>> builder(MarshallingType.LIST)
            .memberName("deleted")
            .getter(getter(BatchDeleteUniqueIdResponse::deleted))
            .setter(setter(Builder::deleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleted").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeletedUniqueId> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeletedUniqueId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DISCONNECTED_UNIQUE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("disconnectedUniqueIds")
            .getter(getter(BatchDeleteUniqueIdResponse::disconnectedUniqueIds))
            .setter(setter(Builder::disconnectedUniqueIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disconnectedUniqueIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DeleteUniqueIdError>> ERRORS_FIELD = SdkField
            .<List<DeleteUniqueIdError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchDeleteUniqueIdResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeleteUniqueIdError> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeleteUniqueIdError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BatchDeleteUniqueIdResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETED_FIELD,
            DISCONNECTED_UNIQUE_IDS_FIELD, ERRORS_FIELD, STATUS_FIELD));

    private final List<DeletedUniqueId> deleted;

    private final List<String> disconnectedUniqueIds;

    private final List<DeleteUniqueIdError> errors;

    private final String status;

    private BatchDeleteUniqueIdResponse(BuilderImpl builder) {
        super(builder);
        this.deleted = builder.deleted;
        this.disconnectedUniqueIds = builder.disconnectedUniqueIds;
        this.errors = builder.errors;
        this.status = builder.status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Deleted property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDeleted() {
        return deleted != null && !(deleted instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique IDs that were deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeleted} method.
     * </p>
     * 
     * @return The unique IDs that were deleted.
     */
    public final List<DeletedUniqueId> deleted() {
        return deleted;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisconnectedUniqueIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDisconnectedUniqueIds() {
        return disconnectedUniqueIds != null && !(disconnectedUniqueIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique IDs that were disconnected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisconnectedUniqueIds} method.
     * </p>
     * 
     * @return The unique IDs that were disconnected.
     */
    public final List<String> disconnectedUniqueIds() {
        return disconnectedUniqueIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The errors from deleting multiple unique IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return The errors from deleting multiple unique IDs.
     */
    public final List<DeleteUniqueIdError> errors() {
        return errors;
    }

    /**
     * <p>
     * The status of the batch delete unique ID operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeleteUniqueIdStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the batch delete unique ID operation.
     * @see DeleteUniqueIdStatus
     */
    public final DeleteUniqueIdStatus status() {
        return DeleteUniqueIdStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the batch delete unique ID operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeleteUniqueIdStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the batch delete unique ID operation.
     * @see DeleteUniqueIdStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeleted() ? deleted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDisconnectedUniqueIds() ? disconnectedUniqueIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteUniqueIdResponse)) {
            return false;
        }
        BatchDeleteUniqueIdResponse other = (BatchDeleteUniqueIdResponse) obj;
        return hasDeleted() == other.hasDeleted() && Objects.equals(deleted(), other.deleted())
                && hasDisconnectedUniqueIds() == other.hasDisconnectedUniqueIds()
                && Objects.equals(disconnectedUniqueIds(), other.disconnectedUniqueIds()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteUniqueIdResponse").add("Deleted", hasDeleted() ? deleted() : null)
                .add("DisconnectedUniqueIds", hasDisconnectedUniqueIds() ? disconnectedUniqueIds() : null)
                .add("Errors", hasErrors() ? errors() : null).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deleted":
            return Optional.ofNullable(clazz.cast(deleted()));
        case "disconnectedUniqueIds":
            return Optional.ofNullable(clazz.cast(disconnectedUniqueIds()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteUniqueIdResponse, T> g) {
        return obj -> g.apply((BatchDeleteUniqueIdResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDeleteUniqueIdResponse> {
        /**
         * <p>
         * The unique IDs that were deleted.
         * </p>
         * 
         * @param deleted
         *        The unique IDs that were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(Collection<DeletedUniqueId> deleted);

        /**
         * <p>
         * The unique IDs that were deleted.
         * </p>
         * 
         * @param deleted
         *        The unique IDs that were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(DeletedUniqueId... deleted);

        /**
         * <p>
         * The unique IDs that were deleted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.DeletedUniqueId.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.DeletedUniqueId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.DeletedUniqueId.Builder#build()} is called
         * immediately and its result is passed to {@link #deleted(List<DeletedUniqueId>)}.
         * 
         * @param deleted
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.DeletedUniqueId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleted(java.util.Collection<DeletedUniqueId>)
         */
        Builder deleted(Consumer<DeletedUniqueId.Builder>... deleted);

        /**
         * <p>
         * The unique IDs that were disconnected.
         * </p>
         * 
         * @param disconnectedUniqueIds
         *        The unique IDs that were disconnected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectedUniqueIds(Collection<String> disconnectedUniqueIds);

        /**
         * <p>
         * The unique IDs that were disconnected.
         * </p>
         * 
         * @param disconnectedUniqueIds
         *        The unique IDs that were disconnected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectedUniqueIds(String... disconnectedUniqueIds);

        /**
         * <p>
         * The errors from deleting multiple unique IDs.
         * </p>
         * 
         * @param errors
         *        The errors from deleting multiple unique IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<DeleteUniqueIdError> errors);

        /**
         * <p>
         * The errors from deleting multiple unique IDs.
         * </p>
         * 
         * @param errors
         *        The errors from deleting multiple unique IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(DeleteUniqueIdError... errors);

        /**
         * <p>
         * The errors from deleting multiple unique IDs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.DeleteUniqueIdError.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.entityresolution.model.DeleteUniqueIdError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.DeleteUniqueIdError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<DeleteUniqueIdError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.DeleteUniqueIdError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<DeleteUniqueIdError>)
         */
        Builder errors(Consumer<DeleteUniqueIdError.Builder>... errors);

        /**
         * <p>
         * The status of the batch delete unique ID operation.
         * </p>
         * 
         * @param status
         *        The status of the batch delete unique ID operation.
         * @see DeleteUniqueIdStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeleteUniqueIdStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the batch delete unique ID operation.
         * </p>
         * 
         * @param status
         *        The status of the batch delete unique ID operation.
         * @see DeleteUniqueIdStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeleteUniqueIdStatus
         */
        Builder status(DeleteUniqueIdStatus status);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private List<DeletedUniqueId> deleted = DefaultSdkAutoConstructList.getInstance();

        private List<String> disconnectedUniqueIds = DefaultSdkAutoConstructList.getInstance();

        private List<DeleteUniqueIdError> errors = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteUniqueIdResponse model) {
            super(model);
            deleted(model.deleted);
            disconnectedUniqueIds(model.disconnectedUniqueIds);
            errors(model.errors);
            status(model.status);
        }

        public final List<DeletedUniqueId.Builder> getDeleted() {
            List<DeletedUniqueId.Builder> result = DeletedUniqueIdListCopier.copyToBuilder(this.deleted);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeleted(Collection<DeletedUniqueId.BuilderImpl> deleted) {
            this.deleted = DeletedUniqueIdListCopier.copyFromBuilder(deleted);
        }

        @Override
        public final Builder deleted(Collection<DeletedUniqueId> deleted) {
            this.deleted = DeletedUniqueIdListCopier.copy(deleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleted(DeletedUniqueId... deleted) {
            deleted(Arrays.asList(deleted));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleted(Consumer<DeletedUniqueId.Builder>... deleted) {
            deleted(Stream.of(deleted).map(c -> DeletedUniqueId.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDisconnectedUniqueIds() {
            if (disconnectedUniqueIds instanceof SdkAutoConstructList) {
                return null;
            }
            return disconnectedUniqueIds;
        }

        public final void setDisconnectedUniqueIds(Collection<String> disconnectedUniqueIds) {
            this.disconnectedUniqueIds = DisconnectedUniqueIdsListCopier.copy(disconnectedUniqueIds);
        }

        @Override
        public final Builder disconnectedUniqueIds(Collection<String> disconnectedUniqueIds) {
            this.disconnectedUniqueIds = DisconnectedUniqueIdsListCopier.copy(disconnectedUniqueIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disconnectedUniqueIds(String... disconnectedUniqueIds) {
            disconnectedUniqueIds(Arrays.asList(disconnectedUniqueIds));
            return this;
        }

        public final List<DeleteUniqueIdError.Builder> getErrors() {
            List<DeleteUniqueIdError.Builder> result = DeleteUniqueIdErrorsListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<DeleteUniqueIdError.BuilderImpl> errors) {
            this.errors = DeleteUniqueIdErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<DeleteUniqueIdError> errors) {
            this.errors = DeleteUniqueIdErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(DeleteUniqueIdError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<DeleteUniqueIdError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> DeleteUniqueIdError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeleteUniqueIdStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public BatchDeleteUniqueIdResponse build() {
            return new BatchDeleteUniqueIdResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
