/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emrserverless.EmrServerlessClient;
import software.amazon.awssdk.services.emrserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.emrserverless.model.JobRunAttemptSummary;
import software.amazon.awssdk.services.emrserverless.model.ListJobRunAttemptsRequest;
import software.amazon.awssdk.services.emrserverless.model.ListJobRunAttemptsResponse;

public class ListJobRunAttemptsIterable
implements SdkIterable<ListJobRunAttemptsResponse> {
    private final EmrServerlessClient client;
    private final ListJobRunAttemptsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobRunAttemptsIterable(EmrServerlessClient client, ListJobRunAttemptsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListJobRunAttemptsResponseFetcher();
    }

    public Iterator<ListJobRunAttemptsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobRunAttemptSummary> jobRunAttempts() {
        Function<ListJobRunAttemptsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobRunAttempts() != null) {
                return response.jobRunAttempts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobRunAttemptsResponseFetcher
    implements SyncPageFetcher<ListJobRunAttemptsResponse> {
        private ListJobRunAttemptsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobRunAttemptsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJobRunAttemptsResponse nextPage(ListJobRunAttemptsResponse previousPage) {
            if (previousPage == null) {
                return ListJobRunAttemptsIterable.this.client.listJobRunAttempts(ListJobRunAttemptsIterable.this.firstRequest);
            }
            return ListJobRunAttemptsIterable.this.client.listJobRunAttempts((ListJobRunAttemptsRequest)((Object)ListJobRunAttemptsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

