/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InteractiveConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InteractiveConfiguration> {
    private static final SdkField<Boolean> STUDIO_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("studioEnabled").getter(InteractiveConfiguration.getter(InteractiveConfiguration::studioEnabled)).setter(InteractiveConfiguration.setter(Builder::studioEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioEnabled").build()}).build();
    private static final SdkField<Boolean> LIVY_ENDPOINT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("livyEndpointEnabled").getter(InteractiveConfiguration.getter(InteractiveConfiguration::livyEndpointEnabled)).setter(InteractiveConfiguration.setter(Builder::livyEndpointEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("livyEndpointEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIO_ENABLED_FIELD, LIVY_ENDPOINT_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InteractiveConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean studioEnabled;
    private final Boolean livyEndpointEnabled;

    private InteractiveConfiguration(BuilderImpl builder) {
        this.studioEnabled = builder.studioEnabled;
        this.livyEndpointEnabled = builder.livyEndpointEnabled;
    }

    public final Boolean studioEnabled() {
        return this.studioEnabled;
    }

    public final Boolean livyEndpointEnabled() {
        return this.livyEndpointEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.studioEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.livyEndpointEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InteractiveConfiguration)) {
            return false;
        }
        InteractiveConfiguration other = (InteractiveConfiguration)obj;
        return Objects.equals(this.studioEnabled(), other.studioEnabled()) && Objects.equals(this.livyEndpointEnabled(), other.livyEndpointEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"InteractiveConfiguration").add("StudioEnabled", (Object)this.studioEnabled()).add("LivyEndpointEnabled", (Object)this.livyEndpointEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "studioEnabled": {
                return Optional.ofNullable(clazz.cast(this.studioEnabled()));
            }
            case "livyEndpointEnabled": {
                return Optional.ofNullable(clazz.cast(this.livyEndpointEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Boolean>> map = new HashMap<String, SdkField<Boolean>>();
        map.put("studioEnabled", STUDIO_ENABLED_FIELD);
        map.put("livyEndpointEnabled", LIVY_ENDPOINT_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InteractiveConfiguration, T> g) {
        return obj -> g.apply((InteractiveConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean studioEnabled;
        private Boolean livyEndpointEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(InteractiveConfiguration model) {
            this.studioEnabled(model.studioEnabled);
            this.livyEndpointEnabled(model.livyEndpointEnabled);
        }

        public final Boolean getStudioEnabled() {
            return this.studioEnabled;
        }

        public final void setStudioEnabled(Boolean studioEnabled) {
            this.studioEnabled = studioEnabled;
        }

        @Override
        public final Builder studioEnabled(Boolean studioEnabled) {
            this.studioEnabled = studioEnabled;
            return this;
        }

        public final Boolean getLivyEndpointEnabled() {
            return this.livyEndpointEnabled;
        }

        public final void setLivyEndpointEnabled(Boolean livyEndpointEnabled) {
            this.livyEndpointEnabled = livyEndpointEnabled;
        }

        @Override
        public final Builder livyEndpointEnabled(Boolean livyEndpointEnabled) {
            this.livyEndpointEnabled = livyEndpointEnabled;
            return this;
        }

        public InteractiveConfiguration build() {
            return new InteractiveConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InteractiveConfiguration> {
        public Builder studioEnabled(Boolean var1);

        public Builder livyEndpointEnabled(Boolean var1);
    }
}

