/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emrserverless.model.PolicyArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobRunExecutionIamPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobRunExecutionIamPolicy> {
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policy").getter(JobRunExecutionIamPolicy.getter(JobRunExecutionIamPolicy::policy)).setter(JobRunExecutionIamPolicy.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final SdkField<List<String>> POLICY_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policyArns").getter(JobRunExecutionIamPolicy.getter(JobRunExecutionIamPolicy::policyArns)).setter(JobRunExecutionIamPolicy.setter(Builder::policyArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD, POLICY_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobRunExecutionIamPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policy;
    private final List<String> policyArns;

    private JobRunExecutionIamPolicy(BuilderImpl builder) {
        this.policy = builder.policy;
        this.policyArns = builder.policyArns;
    }

    public final String policy() {
        return this.policy;
    }

    public final boolean hasPolicyArns() {
        return this.policyArns != null && !(this.policyArns instanceof SdkAutoConstructList);
    }

    public final List<String> policyArns() {
        return this.policyArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyArns() ? this.policyArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRunExecutionIamPolicy)) {
            return false;
        }
        JobRunExecutionIamPolicy other = (JobRunExecutionIamPolicy)obj;
        return Objects.equals(this.policy(), other.policy()) && this.hasPolicyArns() == other.hasPolicyArns() && Objects.equals(this.policyArns(), other.policyArns());
    }

    public final String toString() {
        return ToString.builder((String)"JobRunExecutionIamPolicy").add("Policy", (Object)this.policy()).add("PolicyArns", this.hasPolicyArns() ? this.policyArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "policyArns": {
                return Optional.ofNullable(clazz.cast(this.policyArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policy", POLICY_FIELD);
        map.put("policyArns", POLICY_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobRunExecutionIamPolicy, T> g) {
        return obj -> g.apply((JobRunExecutionIamPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policy;
        private List<String> policyArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobRunExecutionIamPolicy model) {
            this.policy(model.policy);
            this.policyArns(model.policyArns);
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final Collection<String> getPolicyArns() {
            if (this.policyArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.policyArns;
        }

        public final void setPolicyArns(Collection<String> policyArns) {
            this.policyArns = PolicyArnListCopier.copy(policyArns);
        }

        @Override
        public final Builder policyArns(Collection<String> policyArns) {
            this.policyArns = PolicyArnListCopier.copy(policyArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyArns(String ... policyArns) {
            this.policyArns(Arrays.asList(policyArns));
            return this;
        }

        public JobRunExecutionIamPolicy build() {
            return new JobRunExecutionIamPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobRunExecutionIamPolicy> {
        public Builder policy(String var1);

        public Builder policyArns(Collection<String> var1);

        public Builder policyArns(String ... var1);
    }
}

