/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrserverless.model.JobRunMode;
import software.amazon.awssdk.services.emrserverless.model.JobRunState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobRunAttemptSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobRunAttemptSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::applicationId)).setter(JobRunAttemptSummary.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::id)).setter(JobRunAttemptSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::name)).setter(JobRunAttemptSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::modeAsString)).setter(JobRunAttemptSummary.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::arn)).setter(JobRunAttemptSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::createdBy)).setter(JobRunAttemptSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> JOB_CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("jobCreatedAt").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::jobCreatedAt)).setter(JobRunAttemptSummary.setter(Builder::jobCreatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobCreatedAt").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::createdAt)).setter(JobRunAttemptSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::updatedAt)).setter(JobRunAttemptSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::executionRole)).setter(JobRunAttemptSummary.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::stateAsString)).setter(JobRunAttemptSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateDetails").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::stateDetails)).setter(JobRunAttemptSummary.setter(Builder::stateDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDetails").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseLabel").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::releaseLabel)).setter(JobRunAttemptSummary.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::type)).setter(JobRunAttemptSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Integer> ATTEMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("attempt").getter(JobRunAttemptSummary.getter(JobRunAttemptSummary::attempt)).setter(JobRunAttemptSummary.setter(Builder::attempt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attempt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ID_FIELD, NAME_FIELD, MODE_FIELD, ARN_FIELD, CREATED_BY_FIELD, JOB_CREATED_AT_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, EXECUTION_ROLE_FIELD, STATE_FIELD, STATE_DETAILS_FIELD, RELEASE_LABEL_FIELD, TYPE_FIELD, ATTEMPT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobRunAttemptSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String id;
    private final String name;
    private final String mode;
    private final String arn;
    private final String createdBy;
    private final Instant jobCreatedAt;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String executionRole;
    private final String state;
    private final String stateDetails;
    private final String releaseLabel;
    private final String type;
    private final Integer attempt;

    private JobRunAttemptSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.id = builder.id;
        this.name = builder.name;
        this.mode = builder.mode;
        this.arn = builder.arn;
        this.createdBy = builder.createdBy;
        this.jobCreatedAt = builder.jobCreatedAt;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.executionRole = builder.executionRole;
        this.state = builder.state;
        this.stateDetails = builder.stateDetails;
        this.releaseLabel = builder.releaseLabel;
        this.type = builder.type;
        this.attempt = builder.attempt;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final JobRunMode mode() {
        return JobRunMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final String arn() {
        return this.arn;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant jobCreatedAt() {
        return this.jobCreatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final JobRunState state() {
        return JobRunState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateDetails() {
        return this.stateDetails;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final String type() {
        return this.type;
    }

    public final Integer attempt() {
        return this.attempt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.attempt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRunAttemptSummary)) {
            return false;
        }
        JobRunAttemptSummary other = (JobRunAttemptSummary)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.jobCreatedAt(), other.jobCreatedAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateDetails(), other.stateDetails()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.attempt(), other.attempt());
    }

    public final String toString() {
        return ToString.builder((String)"JobRunAttemptSummary").add("ApplicationId", (Object)this.applicationId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Mode", (Object)this.modeAsString()).add("Arn", (Object)this.arn()).add("CreatedBy", (Object)this.createdBy()).add("JobCreatedAt", (Object)this.jobCreatedAt()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("ExecutionRole", (Object)this.executionRole()).add("State", (Object)this.stateAsString()).add("StateDetails", (Object)this.stateDetails()).add("ReleaseLabel", (Object)this.releaseLabel()).add("Type", (Object)this.type()).add("Attempt", (Object)this.attempt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "jobCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.jobCreatedAt()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "stateDetails": {
                return Optional.ofNullable(clazz.cast(this.stateDetails()));
            }
            case "releaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "attempt": {
                return Optional.ofNullable(clazz.cast(this.attempt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("mode", MODE_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("jobCreatedAt", JOB_CREATED_AT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("state", STATE_FIELD);
        map.put("stateDetails", STATE_DETAILS_FIELD);
        map.put("releaseLabel", RELEASE_LABEL_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("attempt", ATTEMPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobRunAttemptSummary, T> g) {
        return obj -> g.apply((JobRunAttemptSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String id;
        private String name;
        private String mode;
        private String arn;
        private String createdBy;
        private Instant jobCreatedAt;
        private Instant createdAt;
        private Instant updatedAt;
        private String executionRole;
        private String state;
        private String stateDetails;
        private String releaseLabel;
        private String type;
        private Integer attempt;

        private BuilderImpl() {
        }

        private BuilderImpl(JobRunAttemptSummary model) {
            this.applicationId(model.applicationId);
            this.id(model.id);
            this.name(model.name);
            this.mode(model.mode);
            this.arn(model.arn);
            this.createdBy(model.createdBy);
            this.jobCreatedAt(model.jobCreatedAt);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.executionRole(model.executionRole);
            this.state(model.state);
            this.stateDetails(model.stateDetails);
            this.releaseLabel(model.releaseLabel);
            this.type(model.type);
            this.attempt(model.attempt);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(JobRunMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getJobCreatedAt() {
            return this.jobCreatedAt;
        }

        public final void setJobCreatedAt(Instant jobCreatedAt) {
            this.jobCreatedAt = jobCreatedAt;
        }

        @Override
        public final Builder jobCreatedAt(Instant jobCreatedAt) {
            this.jobCreatedAt = jobCreatedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JobRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateDetails() {
            return this.stateDetails;
        }

        public final void setStateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
        }

        @Override
        public final Builder stateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            return this;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Integer getAttempt() {
            return this.attempt;
        }

        public final void setAttempt(Integer attempt) {
            this.attempt = attempt;
        }

        @Override
        public final Builder attempt(Integer attempt) {
            this.attempt = attempt;
            return this;
        }

        public JobRunAttemptSummary build() {
            return new JobRunAttemptSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobRunAttemptSummary> {
        public Builder applicationId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder mode(String var1);

        public Builder mode(JobRunMode var1);

        public Builder arn(String var1);

        public Builder createdBy(String var1);

        public Builder jobCreatedAt(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder executionRole(String var1);

        public Builder state(String var1);

        public Builder state(JobRunState var1);

        public Builder stateDetails(String var1);

        public Builder releaseLabel(String var1);

        public Builder type(String var1);

        public Builder attempt(Integer var1);
    }
}

