/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrcontainers.model.JobTemplateData;
import software.amazon.awssdk.services.emrcontainers.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobTemplate> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(JobTemplate.getter(JobTemplate::name)).setter(JobTemplate.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(JobTemplate.getter(JobTemplate::id)).setter(JobTemplate.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(JobTemplate.getter(JobTemplate::arn)).setter(JobTemplate.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(JobTemplate.getter(JobTemplate::createdAt)).setter(JobTemplate.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(JobTemplate.getter(JobTemplate::createdBy)).setter(JobTemplate.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(JobTemplate.getter(JobTemplate::tags)).setter(JobTemplate.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<JobTemplateData> JOB_TEMPLATE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobTemplateData").getter(JobTemplate.getter(JobTemplate::jobTemplateData)).setter(JobTemplate.setter(Builder::jobTemplateData)).constructor(JobTemplateData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateData").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(JobTemplate.getter(JobTemplate::kmsKeyArn)).setter(JobTemplate.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<String> DECRYPTION_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("decryptionError").getter(JobTemplate.getter(JobTemplate::decryptionError)).setter(JobTemplate.setter(Builder::decryptionError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryptionError").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, ARN_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, TAGS_FIELD, JOB_TEMPLATE_DATA_FIELD, KMS_KEY_ARN_FIELD, DECRYPTION_ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final String arn;
    private final Instant createdAt;
    private final String createdBy;
    private final Map<String, String> tags;
    private final JobTemplateData jobTemplateData;
    private final String kmsKeyArn;
    private final String decryptionError;

    private JobTemplate(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.tags = builder.tags;
        this.jobTemplateData = builder.jobTemplateData;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.decryptionError = builder.decryptionError;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final JobTemplateData jobTemplateData() {
        return this.jobTemplateData;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String decryptionError() {
        return this.decryptionError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTemplateData());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.decryptionError());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobTemplate)) {
            return false;
        }
        JobTemplate other = (JobTemplate)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.jobTemplateData(), other.jobTemplateData()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.decryptionError(), other.decryptionError());
    }

    public final String toString() {
        return ToString.builder((String)"JobTemplate").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("Tags", this.hasTags() ? this.tags() : null).add("JobTemplateData", (Object)this.jobTemplateData()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("DecryptionError", (Object)this.decryptionError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "jobTemplateData": {
                return Optional.ofNullable(clazz.cast(this.jobTemplateData()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "decryptionError": {
                return Optional.ofNullable(clazz.cast(this.decryptionError()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobTemplate, T> g) {
        return obj -> g.apply((JobTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String arn;
        private Instant createdAt;
        private String createdBy;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private JobTemplateData jobTemplateData;
        private String kmsKeyArn;
        private String decryptionError;

        private BuilderImpl() {
        }

        private BuilderImpl(JobTemplate model) {
            this.name(model.name);
            this.id(model.id);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.tags(model.tags);
            this.jobTemplateData(model.jobTemplateData);
            this.kmsKeyArn(model.kmsKeyArn);
            this.decryptionError(model.decryptionError);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final JobTemplateData.Builder getJobTemplateData() {
            return this.jobTemplateData != null ? this.jobTemplateData.toBuilder() : null;
        }

        public final void setJobTemplateData(JobTemplateData.BuilderImpl jobTemplateData) {
            this.jobTemplateData = jobTemplateData != null ? jobTemplateData.build() : null;
        }

        @Override
        public final Builder jobTemplateData(JobTemplateData jobTemplateData) {
            this.jobTemplateData = jobTemplateData;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getDecryptionError() {
            return this.decryptionError;
        }

        public final void setDecryptionError(String decryptionError) {
            this.decryptionError = decryptionError;
        }

        @Override
        public final Builder decryptionError(String decryptionError) {
            this.decryptionError = decryptionError;
            return this;
        }

        public JobTemplate build() {
            return new JobTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobTemplate> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder jobTemplateData(JobTemplateData var1);

        default public Builder jobTemplateData(Consumer<JobTemplateData.Builder> jobTemplateData) {
            return this.jobTemplateData((JobTemplateData)((JobTemplateData.Builder)JobTemplateData.builder().applyMutation(jobTemplateData)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder decryptionError(String var1);
    }
}

