/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.EnvironmentVariablesMapCopier;
import software.amazon.awssdk.services.emr.model.ExecutionEngineConfig;
import software.amazon.awssdk.services.emr.model.NotebookS3LocationFromInput;
import software.amazon.awssdk.services.emr.model.OutputNotebookFormat;
import software.amazon.awssdk.services.emr.model.OutputNotebookS3LocationFromInput;
import software.amazon.awssdk.services.emr.model.Tag;
import software.amazon.awssdk.services.emr.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartNotebookExecutionRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, StartNotebookExecutionRequest> {
    private static final SdkField<String> EDITOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EditorId").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::editorId)).setter(StartNotebookExecutionRequest.setter(Builder::editorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EditorId").build()}).build();
    private static final SdkField<String> RELATIVE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelativePath").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::relativePath)).setter(StartNotebookExecutionRequest.setter(Builder::relativePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativePath").build()}).build();
    private static final SdkField<String> NOTEBOOK_EXECUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookExecutionName").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::notebookExecutionName)).setter(StartNotebookExecutionRequest.setter(Builder::notebookExecutionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookExecutionName").build()}).build();
    private static final SdkField<String> NOTEBOOK_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookParams").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::notebookParams)).setter(StartNotebookExecutionRequest.setter(Builder::notebookParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookParams").build()}).build();
    private static final SdkField<ExecutionEngineConfig> EXECUTION_ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionEngine").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::executionEngine)).setter(StartNotebookExecutionRequest.setter(Builder::executionEngine)).constructor(ExecutionEngineConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEngine").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRole").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::serviceRole)).setter(StartNotebookExecutionRequest.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_SECURITY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceSecurityGroupId").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::notebookInstanceSecurityGroupId)).setter(StartNotebookExecutionRequest.setter(Builder::notebookInstanceSecurityGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceSecurityGroupId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::tags)).setter(StartNotebookExecutionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<NotebookS3LocationFromInput> NOTEBOOK_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotebookS3Location").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::notebookS3Location)).setter(StartNotebookExecutionRequest.setter(Builder::notebookS3Location)).constructor(NotebookS3LocationFromInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookS3Location").build()}).build();
    private static final SdkField<OutputNotebookS3LocationFromInput> OUTPUT_NOTEBOOK_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputNotebookS3Location").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::outputNotebookS3Location)).setter(StartNotebookExecutionRequest.setter(Builder::outputNotebookS3Location)).constructor(OutputNotebookS3LocationFromInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputNotebookS3Location").build()}).build();
    private static final SdkField<String> OUTPUT_NOTEBOOK_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputNotebookFormat").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::outputNotebookFormatAsString)).setter(StartNotebookExecutionRequest.setter(Builder::outputNotebookFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputNotebookFormat").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EnvironmentVariables").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::environmentVariables)).setter(StartNotebookExecutionRequest.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDITOR_ID_FIELD, RELATIVE_PATH_FIELD, NOTEBOOK_EXECUTION_NAME_FIELD, NOTEBOOK_PARAMS_FIELD, EXECUTION_ENGINE_FIELD, SERVICE_ROLE_FIELD, NOTEBOOK_INSTANCE_SECURITY_GROUP_ID_FIELD, TAGS_FIELD, NOTEBOOK_S3_LOCATION_FIELD, OUTPUT_NOTEBOOK_S3_LOCATION_FIELD, OUTPUT_NOTEBOOK_FORMAT_FIELD, ENVIRONMENT_VARIABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartNotebookExecutionRequest.memberNameToFieldInitializer();
    private final String editorId;
    private final String relativePath;
    private final String notebookExecutionName;
    private final String notebookParams;
    private final ExecutionEngineConfig executionEngine;
    private final String serviceRole;
    private final String notebookInstanceSecurityGroupId;
    private final List<Tag> tags;
    private final NotebookS3LocationFromInput notebookS3Location;
    private final OutputNotebookS3LocationFromInput outputNotebookS3Location;
    private final String outputNotebookFormat;
    private final Map<String, String> environmentVariables;

    private StartNotebookExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.editorId = builder.editorId;
        this.relativePath = builder.relativePath;
        this.notebookExecutionName = builder.notebookExecutionName;
        this.notebookParams = builder.notebookParams;
        this.executionEngine = builder.executionEngine;
        this.serviceRole = builder.serviceRole;
        this.notebookInstanceSecurityGroupId = builder.notebookInstanceSecurityGroupId;
        this.tags = builder.tags;
        this.notebookS3Location = builder.notebookS3Location;
        this.outputNotebookS3Location = builder.outputNotebookS3Location;
        this.outputNotebookFormat = builder.outputNotebookFormat;
        this.environmentVariables = builder.environmentVariables;
    }

    public final String editorId() {
        return this.editorId;
    }

    public final String relativePath() {
        return this.relativePath;
    }

    public final String notebookExecutionName() {
        return this.notebookExecutionName;
    }

    public final String notebookParams() {
        return this.notebookParams;
    }

    public final ExecutionEngineConfig executionEngine() {
        return this.executionEngine;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final String notebookInstanceSecurityGroupId() {
        return this.notebookInstanceSecurityGroupId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final NotebookS3LocationFromInput notebookS3Location() {
        return this.notebookS3Location;
    }

    public final OutputNotebookS3LocationFromInput outputNotebookS3Location() {
        return this.outputNotebookS3Location;
    }

    public final OutputNotebookFormat outputNotebookFormat() {
        return OutputNotebookFormat.fromValue(this.outputNotebookFormat);
    }

    public final String outputNotebookFormatAsString() {
        return this.outputNotebookFormat;
    }

    public final boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.editorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookParams());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEngine());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputNotebookS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputNotebookFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartNotebookExecutionRequest)) {
            return false;
        }
        StartNotebookExecutionRequest other = (StartNotebookExecutionRequest)((Object)obj);
        return Objects.equals(this.editorId(), other.editorId()) && Objects.equals(this.relativePath(), other.relativePath()) && Objects.equals(this.notebookExecutionName(), other.notebookExecutionName()) && Objects.equals(this.notebookParams(), other.notebookParams()) && Objects.equals(this.executionEngine(), other.executionEngine()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.notebookInstanceSecurityGroupId(), other.notebookInstanceSecurityGroupId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.notebookS3Location(), other.notebookS3Location()) && Objects.equals(this.outputNotebookS3Location(), other.outputNotebookS3Location()) && Objects.equals(this.outputNotebookFormatAsString(), other.outputNotebookFormatAsString()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables());
    }

    public final String toString() {
        return ToString.builder((String)"StartNotebookExecutionRequest").add("EditorId", (Object)this.editorId()).add("RelativePath", (Object)this.relativePath()).add("NotebookExecutionName", (Object)this.notebookExecutionName()).add("NotebookParams", (Object)this.notebookParams()).add("ExecutionEngine", (Object)this.executionEngine()).add("ServiceRole", (Object)this.serviceRole()).add("NotebookInstanceSecurityGroupId", (Object)this.notebookInstanceSecurityGroupId()).add("Tags", this.hasTags() ? this.tags() : null).add("NotebookS3Location", (Object)this.notebookS3Location()).add("OutputNotebookS3Location", (Object)this.outputNotebookS3Location()).add("OutputNotebookFormat", (Object)this.outputNotebookFormatAsString()).add("EnvironmentVariables", this.hasEnvironmentVariables() ? this.environmentVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EditorId": {
                return Optional.ofNullable(clazz.cast(this.editorId()));
            }
            case "RelativePath": {
                return Optional.ofNullable(clazz.cast(this.relativePath()));
            }
            case "NotebookExecutionName": {
                return Optional.ofNullable(clazz.cast(this.notebookExecutionName()));
            }
            case "NotebookParams": {
                return Optional.ofNullable(clazz.cast(this.notebookParams()));
            }
            case "ExecutionEngine": {
                return Optional.ofNullable(clazz.cast(this.executionEngine()));
            }
            case "ServiceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "NotebookInstanceSecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceSecurityGroupId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NotebookS3Location": {
                return Optional.ofNullable(clazz.cast(this.notebookS3Location()));
            }
            case "OutputNotebookS3Location": {
                return Optional.ofNullable(clazz.cast(this.outputNotebookS3Location()));
            }
            case "OutputNotebookFormat": {
                return Optional.ofNullable(clazz.cast(this.outputNotebookFormatAsString()));
            }
            case "EnvironmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EditorId", EDITOR_ID_FIELD);
        map.put("RelativePath", RELATIVE_PATH_FIELD);
        map.put("NotebookExecutionName", NOTEBOOK_EXECUTION_NAME_FIELD);
        map.put("NotebookParams", NOTEBOOK_PARAMS_FIELD);
        map.put("ExecutionEngine", EXECUTION_ENGINE_FIELD);
        map.put("ServiceRole", SERVICE_ROLE_FIELD);
        map.put("NotebookInstanceSecurityGroupId", NOTEBOOK_INSTANCE_SECURITY_GROUP_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("NotebookS3Location", NOTEBOOK_S3_LOCATION_FIELD);
        map.put("OutputNotebookS3Location", OUTPUT_NOTEBOOK_S3_LOCATION_FIELD);
        map.put("OutputNotebookFormat", OUTPUT_NOTEBOOK_FORMAT_FIELD);
        map.put("EnvironmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartNotebookExecutionRequest, T> g) {
        return obj -> g.apply((StartNotebookExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String editorId;
        private String relativePath;
        private String notebookExecutionName;
        private String notebookParams;
        private ExecutionEngineConfig executionEngine;
        private String serviceRole;
        private String notebookInstanceSecurityGroupId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private NotebookS3LocationFromInput notebookS3Location;
        private OutputNotebookS3LocationFromInput outputNotebookS3Location;
        private String outputNotebookFormat;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartNotebookExecutionRequest model) {
            super(model);
            this.editorId(model.editorId);
            this.relativePath(model.relativePath);
            this.notebookExecutionName(model.notebookExecutionName);
            this.notebookParams(model.notebookParams);
            this.executionEngine(model.executionEngine);
            this.serviceRole(model.serviceRole);
            this.notebookInstanceSecurityGroupId(model.notebookInstanceSecurityGroupId);
            this.tags(model.tags);
            this.notebookS3Location(model.notebookS3Location);
            this.outputNotebookS3Location(model.outputNotebookS3Location);
            this.outputNotebookFormat(model.outputNotebookFormat);
            this.environmentVariables(model.environmentVariables);
        }

        public final String getEditorId() {
            return this.editorId;
        }

        public final void setEditorId(String editorId) {
            this.editorId = editorId;
        }

        @Override
        public final Builder editorId(String editorId) {
            this.editorId = editorId;
            return this;
        }

        public final String getRelativePath() {
            return this.relativePath;
        }

        public final void setRelativePath(String relativePath) {
            this.relativePath = relativePath;
        }

        @Override
        public final Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        public final String getNotebookExecutionName() {
            return this.notebookExecutionName;
        }

        public final void setNotebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
        }

        @Override
        public final Builder notebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
            return this;
        }

        public final String getNotebookParams() {
            return this.notebookParams;
        }

        public final void setNotebookParams(String notebookParams) {
            this.notebookParams = notebookParams;
        }

        @Override
        public final Builder notebookParams(String notebookParams) {
            this.notebookParams = notebookParams;
            return this;
        }

        public final ExecutionEngineConfig.Builder getExecutionEngine() {
            return this.executionEngine != null ? this.executionEngine.toBuilder() : null;
        }

        public final void setExecutionEngine(ExecutionEngineConfig.BuilderImpl executionEngine) {
            this.executionEngine = executionEngine != null ? executionEngine.build() : null;
        }

        @Override
        public final Builder executionEngine(ExecutionEngineConfig executionEngine) {
            this.executionEngine = executionEngine;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final String getNotebookInstanceSecurityGroupId() {
            return this.notebookInstanceSecurityGroupId;
        }

        public final void setNotebookInstanceSecurityGroupId(String notebookInstanceSecurityGroupId) {
            this.notebookInstanceSecurityGroupId = notebookInstanceSecurityGroupId;
        }

        @Override
        public final Builder notebookInstanceSecurityGroupId(String notebookInstanceSecurityGroupId) {
            this.notebookInstanceSecurityGroupId = notebookInstanceSecurityGroupId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final NotebookS3LocationFromInput.Builder getNotebookS3Location() {
            return this.notebookS3Location != null ? this.notebookS3Location.toBuilder() : null;
        }

        public final void setNotebookS3Location(NotebookS3LocationFromInput.BuilderImpl notebookS3Location) {
            this.notebookS3Location = notebookS3Location != null ? notebookS3Location.build() : null;
        }

        @Override
        public final Builder notebookS3Location(NotebookS3LocationFromInput notebookS3Location) {
            this.notebookS3Location = notebookS3Location;
            return this;
        }

        public final OutputNotebookS3LocationFromInput.Builder getOutputNotebookS3Location() {
            return this.outputNotebookS3Location != null ? this.outputNotebookS3Location.toBuilder() : null;
        }

        public final void setOutputNotebookS3Location(OutputNotebookS3LocationFromInput.BuilderImpl outputNotebookS3Location) {
            this.outputNotebookS3Location = outputNotebookS3Location != null ? outputNotebookS3Location.build() : null;
        }

        @Override
        public final Builder outputNotebookS3Location(OutputNotebookS3LocationFromInput outputNotebookS3Location) {
            this.outputNotebookS3Location = outputNotebookS3Location;
            return this;
        }

        public final String getOutputNotebookFormat() {
            return this.outputNotebookFormat;
        }

        public final void setOutputNotebookFormat(String outputNotebookFormat) {
            this.outputNotebookFormat = outputNotebookFormat;
        }

        @Override
        public final Builder outputNotebookFormat(String outputNotebookFormat) {
            this.outputNotebookFormat = outputNotebookFormat;
            return this;
        }

        @Override
        public final Builder outputNotebookFormat(OutputNotebookFormat outputNotebookFormat) {
            this.outputNotebookFormat(outputNotebookFormat == null ? null : outputNotebookFormat.toString());
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartNotebookExecutionRequest build() {
            return new StartNotebookExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartNotebookExecutionRequest> {
        public Builder editorId(String var1);

        public Builder relativePath(String var1);

        public Builder notebookExecutionName(String var1);

        public Builder notebookParams(String var1);

        public Builder executionEngine(ExecutionEngineConfig var1);

        default public Builder executionEngine(Consumer<ExecutionEngineConfig.Builder> executionEngine) {
            return this.executionEngine((ExecutionEngineConfig)((ExecutionEngineConfig.Builder)ExecutionEngineConfig.builder().applyMutation(executionEngine)).build());
        }

        public Builder serviceRole(String var1);

        public Builder notebookInstanceSecurityGroupId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder notebookS3Location(NotebookS3LocationFromInput var1);

        default public Builder notebookS3Location(Consumer<NotebookS3LocationFromInput.Builder> notebookS3Location) {
            return this.notebookS3Location((NotebookS3LocationFromInput)((NotebookS3LocationFromInput.Builder)NotebookS3LocationFromInput.builder().applyMutation(notebookS3Location)).build());
        }

        public Builder outputNotebookS3Location(OutputNotebookS3LocationFromInput var1);

        default public Builder outputNotebookS3Location(Consumer<OutputNotebookS3LocationFromInput.Builder> outputNotebookS3Location) {
            return this.outputNotebookS3Location((OutputNotebookS3LocationFromInput)((OutputNotebookS3LocationFromInput.Builder)OutputNotebookS3LocationFromInput.builder().applyMutation(outputNotebookS3Location)).build());
        }

        public Builder outputNotebookFormat(String var1);

        public Builder outputNotebookFormat(OutputNotebookFormat var1);

        public Builder environmentVariables(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

