/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReleaseLabelsResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, ListReleaseLabelsResponse> {
    private static final SdkField<List<String>> RELEASE_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReleaseLabels").getter(ListReleaseLabelsResponse.getter(ListReleaseLabelsResponse::releaseLabels)).setter(ListReleaseLabelsResponse.setter(Builder::releaseLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReleaseLabelsResponse.getter(ListReleaseLabelsResponse::nextToken)).setter(ListReleaseLabelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELEASE_LABELS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReleaseLabelsResponse.memberNameToFieldInitializer();
    private final List<String> releaseLabels;
    private final String nextToken;

    private ListReleaseLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.releaseLabels = builder.releaseLabels;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReleaseLabels() {
        return this.releaseLabels != null && !(this.releaseLabels instanceof SdkAutoConstructList);
    }

    public final List<String> releaseLabels() {
        return this.releaseLabels;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReleaseLabels() ? this.releaseLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReleaseLabelsResponse)) {
            return false;
        }
        ListReleaseLabelsResponse other = (ListReleaseLabelsResponse)((Object)obj);
        return this.hasReleaseLabels() == other.hasReleaseLabels() && Objects.equals(this.releaseLabels(), other.releaseLabels()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListReleaseLabelsResponse").add("ReleaseLabels", this.hasReleaseLabels() ? this.releaseLabels() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReleaseLabels": {
                return Optional.ofNullable(clazz.cast(this.releaseLabels()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReleaseLabels", RELEASE_LABELS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReleaseLabelsResponse, T> g) {
        return obj -> g.apply((ListReleaseLabelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<String> releaseLabels = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReleaseLabelsResponse model) {
            super(model);
            this.releaseLabels(model.releaseLabels);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getReleaseLabels() {
            if (this.releaseLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.releaseLabels;
        }

        public final void setReleaseLabels(Collection<String> releaseLabels) {
            this.releaseLabels = StringListCopier.copy(releaseLabels);
        }

        @Override
        public final Builder releaseLabels(Collection<String> releaseLabels) {
            this.releaseLabels = StringListCopier.copy(releaseLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder releaseLabels(String ... releaseLabels) {
            this.releaseLabels(Arrays.asList(releaseLabels));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReleaseLabelsResponse build() {
            return new ListReleaseLabelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReleaseLabelsResponse> {
        public Builder releaseLabels(Collection<String> var1);

        public Builder releaseLabels(String ... var1);

        public Builder nextToken(String var1);
    }
}

