/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for parameters to <code>PurchaseReservedElasticsearchInstanceOffering</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseReservedElasticsearchInstanceOfferingRequest extends ElasticsearchRequest
        implements
        ToCopyableBuilder<PurchaseReservedElasticsearchInstanceOfferingRequest.Builder, PurchaseReservedElasticsearchInstanceOfferingRequest> {
    private static final SdkField<String> RESERVED_ELASTICSEARCH_INSTANCE_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedElasticsearchInstanceOfferingId")
            .getter(getter(PurchaseReservedElasticsearchInstanceOfferingRequest::reservedElasticsearchInstanceOfferingId))
            .setter(setter(Builder::reservedElasticsearchInstanceOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReservedElasticsearchInstanceOfferingId").build()).build();

    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservationName").getter(getter(PurchaseReservedElasticsearchInstanceOfferingRequest::reservationName))
            .setter(setter(Builder::reservationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationName").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(PurchaseReservedElasticsearchInstanceOfferingRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_ELASTICSEARCH_INSTANCE_OFFERING_ID_FIELD, RESERVATION_NAME_FIELD, INSTANCE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String reservedElasticsearchInstanceOfferingId;

    private final String reservationName;

    private final Integer instanceCount;

    private PurchaseReservedElasticsearchInstanceOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedElasticsearchInstanceOfferingId = builder.reservedElasticsearchInstanceOfferingId;
        this.reservationName = builder.reservationName;
        this.instanceCount = builder.instanceCount;
    }

    /**
     * <p>
     * The ID of the reserved Elasticsearch instance offering to purchase.
     * </p>
     * 
     * @return The ID of the reserved Elasticsearch instance offering to purchase.
     */
    public final String reservedElasticsearchInstanceOfferingId() {
        return reservedElasticsearchInstanceOfferingId;
    }

    /**
     * <p>
     * A customer-specified identifier to track this reservation.
     * </p>
     * 
     * @return A customer-specified identifier to track this reservation.
     */
    public final String reservationName() {
        return reservationName;
    }

    /**
     * <p>
     * The number of Elasticsearch instances to reserve.
     * </p>
     * 
     * @return The number of Elasticsearch instances to reserve.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedElasticsearchInstanceOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(reservationName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedElasticsearchInstanceOfferingRequest)) {
            return false;
        }
        PurchaseReservedElasticsearchInstanceOfferingRequest other = (PurchaseReservedElasticsearchInstanceOfferingRequest) obj;
        return Objects.equals(reservedElasticsearchInstanceOfferingId(), other.reservedElasticsearchInstanceOfferingId())
                && Objects.equals(reservationName(), other.reservationName())
                && Objects.equals(instanceCount(), other.instanceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseReservedElasticsearchInstanceOfferingRequest")
                .add("ReservedElasticsearchInstanceOfferingId", reservedElasticsearchInstanceOfferingId())
                .add("ReservationName", reservationName()).add("InstanceCount", instanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedElasticsearchInstanceOfferingId":
            return Optional.ofNullable(clazz.cast(reservedElasticsearchInstanceOfferingId()));
        case "ReservationName":
            return Optional.ofNullable(clazz.cast(reservationName()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReservedElasticsearchInstanceOfferingId", RESERVED_ELASTICSEARCH_INSTANCE_OFFERING_ID_FIELD);
        map.put("ReservationName", RESERVATION_NAME_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedElasticsearchInstanceOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedElasticsearchInstanceOfferingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticsearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PurchaseReservedElasticsearchInstanceOfferingRequest> {
        /**
         * <p>
         * The ID of the reserved Elasticsearch instance offering to purchase.
         * </p>
         * 
         * @param reservedElasticsearchInstanceOfferingId
         *        The ID of the reserved Elasticsearch instance offering to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId);

        /**
         * <p>
         * A customer-specified identifier to track this reservation.
         * </p>
         * 
         * @param reservationName
         *        A customer-specified identifier to track this reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationName(String reservationName);

        /**
         * <p>
         * The number of Elasticsearch instances to reserve.
         * </p>
         * 
         * @param instanceCount
         *        The number of Elasticsearch instances to reserve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticsearchRequest.BuilderImpl implements Builder {
        private String reservedElasticsearchInstanceOfferingId;

        private String reservationName;

        private Integer instanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedElasticsearchInstanceOfferingRequest model) {
            super(model);
            reservedElasticsearchInstanceOfferingId(model.reservedElasticsearchInstanceOfferingId);
            reservationName(model.reservationName);
            instanceCount(model.instanceCount);
        }

        public final String getReservedElasticsearchInstanceOfferingId() {
            return reservedElasticsearchInstanceOfferingId;
        }

        public final void setReservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
        }

        @Override
        public final Builder reservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
            return this;
        }

        public final String getReservationName() {
            return reservationName;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedElasticsearchInstanceOfferingRequest build() {
            return new PurchaseReservedElasticsearchInstanceOfferingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
