/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the domain properties that are currently being modified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyingProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ModifyingProperties.Builder, ModifyingProperties> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ModifyingProperties::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ACTIVE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveValue").getter(getter(ModifyingProperties::activeValue)).setter(setter(Builder::activeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveValue").build()).build();

    private static final SdkField<String> PENDING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PendingValue").getter(getter(ModifyingProperties::pendingValue)).setter(setter(Builder::pendingValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingValue").build()).build();

    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueType").getter(getter(ModifyingProperties::valueTypeAsString)).setter(setter(Builder::valueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ACTIVE_VALUE_FIELD, PENDING_VALUE_FIELD, VALUE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String activeValue;

    private final String pendingValue;

    private final String valueType;

    private ModifyingProperties(BuilderImpl builder) {
        this.name = builder.name;
        this.activeValue = builder.activeValue;
        this.pendingValue = builder.pendingValue;
        this.valueType = builder.valueType;
    }

    /**
     * <p>
     * The name of the property that is currently being modified.
     * </p>
     * 
     * @return The name of the property that is currently being modified.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current value of the domain property that is being modified.
     * </p>
     * 
     * @return The current value of the domain property that is being modified.
     */
    public final String activeValue() {
        return activeValue;
    }

    /**
     * <p>
     * The value that the property that is currently being modified will eventually have.
     * </p>
     * 
     * @return The value that the property that is currently being modified will eventually have.
     */
    public final String pendingValue() {
        return pendingValue;
    }

    /**
     * <p>
     * The type of value that is currently being modified. Properties can have two types:
     * </p>
     * <ul>
     * <li><b>PLAIN_TEXT</b>: Contain direct values such as "1", "True", or "c5.large.search".</li>
     * <li><b>STRINGIFIED_JSON</b>: Contain content in JSON format, such as {"Enabled":"True"}".</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link PropertyValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The type of value that is currently being modified. Properties can have two types:</p>
     *         <ul>
     *         <li><b>PLAIN_TEXT</b>: Contain direct values such as "1", "True", or "c5.large.search".</li>
     *         <li><b>STRINGIFIED_JSON</b>: Contain content in JSON format, such as {"Enabled":"True"}".</li>
     * @see PropertyValueType
     */
    public final PropertyValueType valueType() {
        return PropertyValueType.fromValue(valueType);
    }

    /**
     * <p>
     * The type of value that is currently being modified. Properties can have two types:
     * </p>
     * <ul>
     * <li><b>PLAIN_TEXT</b>: Contain direct values such as "1", "True", or "c5.large.search".</li>
     * <li><b>STRINGIFIED_JSON</b>: Contain content in JSON format, such as {"Enabled":"True"}".</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link PropertyValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The type of value that is currently being modified. Properties can have two types:</p>
     *         <ul>
     *         <li><b>PLAIN_TEXT</b>: Contain direct values such as "1", "True", or "c5.large.search".</li>
     *         <li><b>STRINGIFIED_JSON</b>: Contain content in JSON format, such as {"Enabled":"True"}".</li>
     * @see PropertyValueType
     */
    public final String valueTypeAsString() {
        return valueType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(activeValue());
        hashCode = 31 * hashCode + Objects.hashCode(pendingValue());
        hashCode = 31 * hashCode + Objects.hashCode(valueTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyingProperties)) {
            return false;
        }
        ModifyingProperties other = (ModifyingProperties) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(activeValue(), other.activeValue())
                && Objects.equals(pendingValue(), other.pendingValue())
                && Objects.equals(valueTypeAsString(), other.valueTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyingProperties").add("Name", name()).add("ActiveValue", activeValue())
                .add("PendingValue", pendingValue()).add("ValueType", valueTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ActiveValue":
            return Optional.ofNullable(clazz.cast(activeValue()));
        case "PendingValue":
            return Optional.ofNullable(clazz.cast(pendingValue()));
        case "ValueType":
            return Optional.ofNullable(clazz.cast(valueTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ActiveValue", ACTIVE_VALUE_FIELD);
        map.put("PendingValue", PENDING_VALUE_FIELD);
        map.put("ValueType", VALUE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyingProperties, T> g) {
        return obj -> g.apply((ModifyingProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModifyingProperties> {
        /**
         * <p>
         * The name of the property that is currently being modified.
         * </p>
         * 
         * @param name
         *        The name of the property that is currently being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current value of the domain property that is being modified.
         * </p>
         * 
         * @param activeValue
         *        The current value of the domain property that is being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeValue(String activeValue);

        /**
         * <p>
         * The value that the property that is currently being modified will eventually have.
         * </p>
         * 
         * @param pendingValue
         *        The value that the property that is currently being modified will eventually have.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingValue(String pendingValue);

        /**
         * <p>
         * The type of value that is currently being modified. Properties can have two types:
         * </p>
         * <ul>
         * <li><b>PLAIN_TEXT</b>: Contain direct values such as "1", "True", or "c5.large.search".</li>
         * <li><b>STRINGIFIED_JSON</b>: Contain content in JSON format, such as {"Enabled":"True"}".</li>
         * </ul>
         * 
         * @param valueType
         *        The type of value that is currently being modified. Properties can have two types:</p>
         *        <ul>
         *        <li><b>PLAIN_TEXT</b>: Contain direct values such as "1", "True", or "c5.large.search".</li>
         *        <li><b>STRINGIFIED_JSON</b>: Contain content in JSON format, such as {"Enabled":"True"}".</li>
         * @see PropertyValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyValueType
         */
        Builder valueType(String valueType);

        /**
         * <p>
         * The type of value that is currently being modified. Properties can have two types:
         * </p>
         * <ul>
         * <li><b>PLAIN_TEXT</b>: Contain direct values such as "1", "True", or "c5.large.search".</li>
         * <li><b>STRINGIFIED_JSON</b>: Contain content in JSON format, such as {"Enabled":"True"}".</li>
         * </ul>
         * 
         * @param valueType
         *        The type of value that is currently being modified. Properties can have two types:</p>
         *        <ul>
         *        <li><b>PLAIN_TEXT</b>: Contain direct values such as "1", "True", or "c5.large.search".</li>
         *        <li><b>STRINGIFIED_JSON</b>: Contain content in JSON format, such as {"Enabled":"True"}".</li>
         * @see PropertyValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropertyValueType
         */
        Builder valueType(PropertyValueType valueType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String activeValue;

        private String pendingValue;

        private String valueType;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyingProperties model) {
            name(model.name);
            activeValue(model.activeValue);
            pendingValue(model.pendingValue);
            valueType(model.valueType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getActiveValue() {
            return activeValue;
        }

        public final void setActiveValue(String activeValue) {
            this.activeValue = activeValue;
        }

        @Override
        public final Builder activeValue(String activeValue) {
            this.activeValue = activeValue;
            return this;
        }

        public final String getPendingValue() {
            return pendingValue;
        }

        public final void setPendingValue(String pendingValue) {
            this.pendingValue = pendingValue;
        }

        @Override
        public final Builder pendingValue(String pendingValue) {
            this.pendingValue = pendingValue;
            return this;
        }

        public final String getValueType() {
            return valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(PropertyValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        @Override
        public ModifyingProperties build() {
            return new ModifyingProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
